/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.file.dfs;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.utils.GsonUtil;
import com.antgroup.geaflow.file.FileConfigKeys;
import com.antgroup.geaflow.file.FileInfo;
import com.antgroup.geaflow.file.IPersistentIO;
import com.antgroup.geaflow.file.PersistentType;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsIO
implements IPersistentIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(DfsIO.class);
    private static final String DFS_URI_KEY = "fs.defaultFS";
    protected static final String LOCAL_FILE_IMPL = "fs.file.impl";
    protected FileSystem fileSystem;

    public void init(Configuration userConfig) {
        String jsonConfig = (String)Preconditions.checkNotNull((Object)userConfig.getString(FileConfigKeys.JSON_CONFIG));
        Map persistConfig = GsonUtil.parse((String)jsonConfig);
        Preconditions.checkArgument((boolean)persistConfig.containsKey(DFS_URI_KEY), (Object)"fs.defaultFS must be set");
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        conf.set(LOCAL_FILE_IMPL, LocalFileSystem.class.getCanonicalName());
        for (Map.Entry entry : persistConfig.entrySet()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            this.fileSystem = FileSystem.newInstance((URI)this.getURIFromConf(conf), (org.apache.hadoop.conf.Configuration)conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected URI getURIFromConf(org.apache.hadoop.conf.Configuration configuration) throws URISyntaxException {
        return new URI(configuration.get(DFS_URI_KEY));
    }

    public List<String> listFile(Path path) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (FileStatus status : this.fileSystem.listStatus(path)) {
            fileNames.add(status.getPath().getName());
        }
        return fileNames;
    }

    public boolean exists(Path path) throws IOException {
        return this.fileSystem.exists(path);
    }

    public void delete(Path path, boolean recursive) throws IOException {
        if (this.exists(path)) {
            this.fileSystem.delete(path, recursive);
        }
    }

    public boolean rename(Path from, Path to) throws IOException {
        if (this.exists(to)) {
            this.fileSystem.delete(to, false);
        }
        return this.fileSystem.rename(from, to);
    }

    public boolean createNewFile(Path path) throws IOException {
        if (!this.fileSystem.exists(path.getParent())) {
            this.fileSystem.mkdirs(path.getParent());
        }
        return this.fileSystem.createNewFile(path);
    }

    public void copyFromLocalFile(Path local, Path remote) throws IOException {
        this.fileSystem.copyFromLocalFile(false, true, local, remote);
    }

    public void copyToLocalFile(Path remote, Path local) throws IOException {
        this.fileSystem.copyToLocalFile(false, remote, local, true);
    }

    public long getRemoteFileSize(Path path) throws IOException {
        FileStatus status = this.fileSystem.getFileStatus(path);
        return status.getLen();
    }

    public long getFileCount(Path path) throws IOException {
        ContentSummary summary = this.fileSystem.getContentSummary(path);
        return summary.getFileCount();
    }

    public FileInfo getFileInfo(Path path) throws IOException {
        FileStatus status = this.fileSystem.getFileStatus(path);
        return FileInfo.of((FileStatus)status);
    }

    public FileInfo[] listStatus(Path path, PathFilter filter) throws IOException {
        FileStatus[] fileStatuses = this.fileSystem.listStatus(path, filter);
        FileInfo[] fileInfos = new FileInfo[fileStatuses.length];
        for (int i = 0; i < fileStatuses.length; ++i) {
            fileInfos[i] = FileInfo.of((FileStatus)fileStatuses[i]);
        }
        return fileInfos;
    }

    public FileInfo[] listStatus(Path path) throws IOException {
        FileStatus[] fileStatuses = this.fileSystem.listStatus(path);
        FileInfo[] fileInfos = new FileInfo[fileStatuses.length];
        for (int i = 0; i < fileStatuses.length; ++i) {
            fileInfos[i] = FileInfo.of((FileStatus)fileStatuses[i]);
        }
        return fileInfos;
    }

    public InputStream open(Path path) throws IOException {
        return this.fileSystem.open(path);
    }

    public void close() throws IOException {
        this.fileSystem.close();
    }

    public PersistentType getPersistentType() {
        return PersistentType.DFS;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }
}

