/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.file.dfs;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.file.FileConfigKeys;
import com.antgroup.geaflow.file.PersistentType;
import com.antgroup.geaflow.file.dfs.DfsIO;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalIO
extends DfsIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalIO.class);
    private static final String LOCAL = "file:///";

    @Override
    public void init(Configuration userConfig) {
        String root = userConfig.contains(FileConfigKeys.ROOT) ? userConfig.getString(FileConfigKeys.ROOT) : userConfig.getString(ExecutionConfigKeys.JOB_WORK_PATH) + userConfig.getString(FileConfigKeys.ROOT);
        LOGGER.info("use local chk path {}", (Object)root);
        try {
            FileUtils.forceMkdir((File)new File(root));
        }
        catch (IOException e) {
            throw new GeaflowRuntimeException("mkdir fail " + root, (Throwable)e);
        }
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        conf.set("fs.file.impl", LocalFileSystem.class.getCanonicalName());
        try {
            this.fileSystem = FileSystem.newInstance((URI)new URI(LOCAL), (org.apache.hadoop.conf.Configuration)conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PersistentType getPersistentType() {
        return PersistentType.LOCAL;
    }
}

