/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.file.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.antgroup.geaflow.common.config.ConfigKey;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.utils.GsonUtil;
import com.antgroup.geaflow.file.FileConfigKeys;
import com.antgroup.geaflow.file.FileInfo;
import com.antgroup.geaflow.file.IPersistentIO;
import com.antgroup.geaflow.file.PersistentType;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class OssIO
implements IPersistentIO {
    private OSSClient ossClient;
    private String bucketName;

    public void init(Configuration userConfig) {
        String jsonConfig = (String)Preconditions.checkNotNull((Object)userConfig.getString(FileConfigKeys.JSON_CONFIG));
        Map persistConfig = GsonUtil.parse((String)jsonConfig);
        this.bucketName = Configuration.getString((ConfigKey)FileConfigKeys.OSS_BUCKET_NAME, (Map)persistConfig);
        String endpoint = Configuration.getString((ConfigKey)FileConfigKeys.OSS_ENDPOINT, (Map)persistConfig);
        String accessKeyId = Configuration.getString((ConfigKey)FileConfigKeys.OSS_ACCESS_ID, (Map)persistConfig);
        String accessKeySecret = Configuration.getString((ConfigKey)FileConfigKeys.OSS_SECRET_KEY, (Map)persistConfig);
        this.ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
    }

    public List<String> listFile(Path path) throws IOException {
        FileInfo[] infos = this.listStatus(path);
        return Arrays.stream(infos).map(c -> c.getPath().getName()).collect(Collectors.toList());
    }

    public boolean exists(Path path) throws IOException {
        boolean existFile = this.ossClient.doesObjectExist(this.bucketName, this.pathToKey(path));
        if (!existFile) {
            ObjectListing objectListing = this.ossClient.listObjects(this.bucketName, this.keyToPrefix(this.pathToKey(path)));
            return objectListing.getObjectSummaries().size() > 0;
        }
        return true;
    }

    public void delete(Path path, boolean recursive) throws IOException {
        String key = this.pathToKey(path);
        if (recursive) {
            ObjectListing objectListing;
            String nextMarker = null;
            ListObjectsRequest request = new ListObjectsRequest(this.bucketName);
            request.setPrefix(this.keyToPrefix(key));
            do {
                request.setMarker(nextMarker);
                Preconditions.checkArgument((request.getPrefix() != null && request.getPrefix().length() > 0 ? 1 : 0) != 0);
                objectListing = this.ossClient.listObjects(request);
                List sums = objectListing.getObjectSummaries();
                ArrayList<String> files = new ArrayList<String>();
                for (OSSObjectSummary s : sums) {
                    files.add(s.getKey());
                }
                nextMarker = objectListing.getNextMarker();
                if (files.isEmpty()) continue;
                this.ossClient.deleteObjects(new DeleteObjectsRequest(this.bucketName).withKeys(files));
            } while (objectListing.isTruncated());
        } else {
            this.ossClient.deleteObject(this.bucketName, key);
        }
    }

    public boolean rename(Path from, Path to) throws IOException {
        ObjectListing objectListing;
        String fromKey = this.pathToKey(from);
        String toKey = this.pathToKey(to);
        String nextMarker = null;
        ListObjectsRequest request = new ListObjectsRequest(this.bucketName);
        request.setPrefix(this.keyToPrefix(fromKey));
        do {
            request.setMarker(nextMarker);
            Preconditions.checkArgument((request.getPrefix() != null && request.getPrefix().length() > 0 ? 1 : 0) != 0);
            objectListing = this.ossClient.listObjects(request);
            List sums = objectListing.getObjectSummaries();
            for (OSSObjectSummary s : sums) {
                String key = s.getKey();
                String newKey = key.replace(fromKey, toKey);
                this.ossClient.copyObject(this.bucketName, key, this.bucketName, newKey);
                this.ossClient.deleteObject(this.bucketName, key);
            }
            nextMarker = objectListing.getNextMarker();
        } while (objectListing.isTruncated());
        fromKey = this.pathToKey(from);
        toKey = this.pathToKey(to);
        if (!from.toString().endsWith("/") && !to.toString().endsWith("/") && this.ossClient.doesObjectExist(this.bucketName, fromKey)) {
            this.ossClient.copyObject(this.bucketName, fromKey, this.bucketName, toKey);
            this.ossClient.deleteObject(this.bucketName, fromKey);
        }
        return true;
    }

    public boolean createNewFile(Path path) throws IOException {
        if (this.exists(path)) {
            return false;
        }
        this.ossClient.putObject(this.bucketName, this.pathToKey(path), (InputStream)new ByteArrayInputStream(new byte[0]));
        return true;
    }

    public void copyFromLocalFile(Path local, Path remote) throws IOException {
        this.ossClient.putObject(this.bucketName, this.pathToKey(remote), new File(local.toString()));
    }

    public void copyToLocalFile(Path remote, Path local) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)this.open(remote), (File)new File(local.toString()));
    }

    public long getRemoteFileSize(Path path) throws IOException {
        OSSObject ossObject = this.ossClient.getObject(this.bucketName, this.pathToKey(path));
        return ossObject.getObjectMetadata().getContentLength();
    }

    public long getFileCount(Path path) throws IOException {
        ObjectListing objectListing;
        long count = 0L;
        String nextMarker = null;
        ListObjectsRequest request = new ListObjectsRequest(this.bucketName);
        request.setPrefix(this.keyToPrefix(this.pathToKey(path)));
        do {
            request.setMarker(nextMarker);
            objectListing = this.ossClient.listObjects(request);
            count += (long)objectListing.getObjectSummaries().size();
            nextMarker = objectListing.getNextMarker();
        } while (objectListing.isTruncated());
        return count;
    }

    public FileInfo getFileInfo(Path path) throws IOException {
        ObjectMetadata obj = this.ossClient.getObjectMetadata(this.bucketName, this.pathToKey(path));
        return FileInfo.of().withPath(path).withLength(obj.getContentLength()).withModifiedTime(obj.getLastModified().getTime());
    }

    public FileInfo[] listStatus(Path path, PathFilter filter) throws IOException {
        List<FileInfo> res = Arrays.asList(this.listStatus(path));
        return (FileInfo[])res.stream().filter(c -> filter.accept(c.getPath())).toArray(FileInfo[]::new);
    }

    public FileInfo[] listStatus(Path path) throws IOException {
        ObjectListing objectListing;
        HashSet<FileInfo> res = new HashSet<FileInfo>();
        String nextMarker = null;
        ListObjectsRequest request = new ListObjectsRequest(this.bucketName);
        request.setPrefix(this.keyToPrefix(this.pathToKey(path)));
        int prefixLen = request.getPrefix().length();
        do {
            request.setMarker(nextMarker);
            objectListing = this.ossClient.listObjects(request);
            List sums = objectListing.getObjectSummaries();
            for (OSSObjectSummary s : sums) {
                long modifiedTime;
                Path filePath;
                String str = s.getKey().substring(prefixLen);
                int nextPos = str.indexOf(47);
                if (nextPos == -1) {
                    filePath = new Path(this.keyToPath(s.getKey()));
                    modifiedTime = s.getLastModified().getTime();
                } else {
                    filePath = new Path(this.keyToPath(request.getPrefix() + str.substring(0, nextPos)));
                    modifiedTime = 0L;
                }
                FileInfo fileInfo = FileInfo.of().withPath(filePath).withLength(s.getSize()).withModifiedTime(modifiedTime);
                res.add(fileInfo);
            }
            nextMarker = objectListing.getNextMarker();
        } while (objectListing.isTruncated());
        return res.toArray(new FileInfo[0]);
    }

    public InputStream open(Path path) throws IOException {
        OSSObject ossObject = this.ossClient.getObject(this.bucketName, this.pathToKey(path));
        return ossObject.getObjectContent();
    }

    public void close() throws IOException {
        this.ossClient.shutdown();
    }

    public PersistentType getPersistentType() {
        return PersistentType.OSS;
    }

    private String keyToPath(String key) {
        return "/" + key;
    }

    private String pathToKey(Path path) {
        String strPath = path.toUri().getPath();
        if (strPath.charAt(0) == '/') {
            return strPath.substring(1);
        }
        return strPath;
    }

    private String keyToPrefix(String key) {
        if (key.charAt(key.length() - 1) == '/') {
            return key;
        }
        return key + "/";
    }
}

