/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.ha.service;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.ha.service.HAServiceType;
import com.antgroup.geaflow.ha.service.IHAService;
import com.antgroup.geaflow.ha.service.MemoryHAService;
import com.antgroup.geaflow.ha.service.RedisHAService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HAServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HAServiceFactory.class);
    private static IHAService haService;

    public static synchronized IHAService getService(Configuration configuration) {
        if (haService == null) {
            String serviceType = configuration.getString(ExecutionConfigKeys.HA_SERVICE_TYPE);
            if (StringUtils.isEmpty((CharSequence)serviceType)) {
                serviceType = configuration.getBoolean(ExecutionConfigKeys.RUN_LOCAL_MODE) ? HAServiceType.memory.name() : HAServiceType.redis.name();
            }
            haService = HAServiceFactory.createHAService(serviceType);
            haService.open(configuration);
        }
        return haService;
    }

    public static IHAService getService() {
        if (haService == null) {
            throw new GeaflowRuntimeException("HAService not initialized");
        }
        return haService;
    }

    private static IHAService createHAService(String serviceType) {
        if (serviceType.equalsIgnoreCase(HAServiceType.redis.name())) {
            return new RedisHAService();
        }
        LOGGER.warn("unknown ha service type:{}, use default memoryHaService", (Object)serviceType);
        return new MemoryHAService();
    }
}

