/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.ha.leaderelection;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.ha.leaderelection.ILeaderElectionService;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElectionServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderElectionServiceFactory.class);

    public static ILeaderElectionService loadElectionService(Configuration configuration) {
        String leaderElectionServiceType = configuration.getString(ExecutionConfigKeys.LEADER_ELECTION_TYPE);
        ServiceLoader<ILeaderElectionService> contextLoader = ServiceLoader.load(ILeaderElectionService.class);
        for (ILeaderElectionService service : contextLoader) {
            if (!service.getType().name().equalsIgnoreCase(leaderElectionServiceType)) continue;
            LOGGER.info("load ILeaderElectionService implementation {} with type {}", (Object)service.getClass().getName(), (Object)leaderElectionServiceType);
            return service;
        }
        LOGGER.error("Not found ILeaderElectionService implementation with type {}", (Object)leaderElectionServiceType);
        throw new GeaflowRuntimeException(RuntimeErrors.INST.spiNotFoundError(ILeaderElectionService.class.getSimpleName()));
    }
}

