/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.ha.service;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.ha.service.AbstractHAService;
import com.antgroup.geaflow.ha.service.ResourceData;
import com.antgroup.geaflow.state.DataModel;
import com.antgroup.geaflow.state.StoreType;
import com.antgroup.geaflow.state.serializer.DefaultKVSerializer;
import com.antgroup.geaflow.state.serializer.IKeySerializer;
import com.antgroup.geaflow.store.IStoreBuilder;
import com.antgroup.geaflow.store.api.key.IKVStore;
import com.antgroup.geaflow.store.api.key.StoreBuilderFactory;
import com.antgroup.geaflow.store.context.StoreContext;
import com.antgroup.geaflow.store.redis.KVRedisStore;

public class RedisHAService
extends AbstractHAService {
    @Override
    public void open(Configuration configuration) {
        super.open(configuration);
        IStoreBuilder builder = StoreBuilderFactory.build((String)StoreType.REDIS.name());
        this.kvStore = (KVRedisStore)builder.getStore(DataModel.KV, configuration);
        String namespace = configuration.getString(ExecutionConfigKeys.JOB_UNIQUE_ID) + "WORKERS_";
        StoreContext storeContext = new StoreContext(namespace);
        storeContext.withKeySerializer((IKeySerializer)new DefaultKVSerializer(String.class, null));
        storeContext.withConfig(configuration);
        this.kvStore.init(storeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(String resourceId, ResourceData resourceData) {
        IKVStore iKVStore = this.kvStore;
        synchronized (iKVStore) {
            this.kvStore.put((Object)resourceId, (Object)resourceData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResourceData getResourceData(String resourceId) {
        IKVStore iKVStore = this.kvStore;
        synchronized (iKVStore) {
            return (ResourceData)this.kvStore.get((Object)resourceId);
        }
    }
}

