/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.FrameworkConfigKeys;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.infer.InferEnvironmentContext;
import com.antgroup.geaflow.infer.InferEnvironmentManager;
import com.antgroup.geaflow.infer.InferTaskRunImpl;
import com.antgroup.geaflow.infer.exchange.DataExchangeContext;
import com.antgroup.geaflow.infer.exchange.impl.InferDataBridgeImpl;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferContext<OUT>
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InferContext.class);
    private final DataExchangeContext shareMemoryContext;
    private final String userDataTransformClass;
    private final String sendQueueKey;
    private final String receiveQueueKey;
    private InferTaskRunImpl inferTaskRunner;
    private InferDataBridgeImpl<OUT> dataBridge;

    public InferContext(Configuration config) {
        this.shareMemoryContext = new DataExchangeContext(config);
        this.receiveQueueKey = this.shareMemoryContext.getReceiveQueueKey();
        this.sendQueueKey = this.shareMemoryContext.getSendQueueKey();
        this.userDataTransformClass = config.getString(FrameworkConfigKeys.INFER_ENV_USER_TRANSFORM_CLASSNAME);
        Preconditions.checkNotNull((Object)this.userDataTransformClass, (Object)(FrameworkConfigKeys.INFER_ENV_USER_TRANSFORM_CLASSNAME.getKey() + " param must be not null"));
        this.dataBridge = new InferDataBridgeImpl(this.shareMemoryContext);
        this.init();
    }

    private void init() {
        try {
            InferEnvironmentContext inferEnvironmentContext = this.getInferEnvironmentContext();
            this.runInferTask(inferEnvironmentContext);
        }
        catch (Exception e) {
            throw new GeaflowRuntimeException("infer context init failed", (Throwable)e);
        }
    }

    public OUT infer(Object ... feature) throws Exception {
        try {
            this.dataBridge.write(feature);
            return this.dataBridge.read();
        }
        catch (Exception e) {
            this.inferTaskRunner.stop();
            LOGGER.error("model infer read result error, python process stopped", (Throwable)e);
            throw new GeaflowRuntimeException("receive infer result exception", (Throwable)e);
        }
    }

    private InferEnvironmentContext getInferEnvironmentContext() {
        boolean initFinished = InferEnvironmentManager.checkInferEnvironmentStatus();
        while (!initFinished) {
            InferEnvironmentManager.checkError();
            initFinished = InferEnvironmentManager.checkInferEnvironmentStatus();
        }
        return InferEnvironmentManager.getEnvironmentContext();
    }

    private void runInferTask(InferEnvironmentContext inferEnvironmentContext) {
        this.inferTaskRunner = new InferTaskRunImpl(inferEnvironmentContext);
        ArrayList<String> runCommands = new ArrayList<String>();
        runCommands.add(inferEnvironmentContext.getPythonExec());
        runCommands.add(inferEnvironmentContext.getInferScript());
        runCommands.add(inferEnvironmentContext.getInferTFClassNameParam(this.userDataTransformClass));
        runCommands.add(inferEnvironmentContext.getInferShareMemoryInputParam(this.receiveQueueKey));
        runCommands.add(inferEnvironmentContext.getInferShareMemoryOutputParam(this.sendQueueKey));
        this.inferTaskRunner.run(runCommands);
    }

    @Override
    public void close() {
        if (this.inferTaskRunner != null) {
            this.inferTaskRunner.stop();
            LOGGER.info("infer task stop after close");
        }
    }
}

