/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.infer.InferEnvironmentContext;
import com.antgroup.geaflow.infer.util.InferFileUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferDependencyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(InferDependencyManager.class);
    private static final String ENV_RUNNER_SH = "infer/env/install-infer-env.sh";
    private static final String INFER_RUNTIME_PATH = "infer/inferRuntime";
    private static final String FILE_IN_JAR_PREFIX = "/";
    private final InferEnvironmentContext environmentContext;
    private final Configuration config;
    private String buildInferEnvShellPath;
    private String inferEnvRequirementsPath;

    public InferDependencyManager(InferEnvironmentContext environmentContext) {
        this.environmentContext = environmentContext;
        this.config = environmentContext.getJobConfig();
        this.init();
    }

    private void init() {
        List<String> inferRuntimeFiles = this.buildInferRuntimeFiles();
        for (String inferRuntimeFile : inferRuntimeFiles) {
            InferFileUtils.copyInferFileByURL(this.environmentContext.getInferFilesDirectory(), inferRuntimeFile);
        }
        String pythonFilesDirectory = this.environmentContext.getInferFilesDirectory();
        InferFileUtils.prepareInferFilesFromJars(pythonFilesDirectory);
        this.inferEnvRequirementsPath = pythonFilesDirectory + File.separator + "requirements.txt";
        this.buildInferEnvShellPath = InferFileUtils.copyInferFileByURL(this.environmentContext.getVirtualEnvDirectory(), ENV_RUNNER_SH);
    }

    public String getBuildInferEnvShellPath() {
        return this.buildInferEnvShellPath;
    }

    public String getInferEnvRequirementsPath() {
        return this.inferEnvRequirementsPath;
    }

    private List<String> buildInferRuntimeFiles() {
        List<String> runtimeFiles;
        try {
            List<Path> filePaths = InferFileUtils.getPathsFromResourceJAR(INFER_RUNTIME_PATH);
            runtimeFiles = filePaths.stream().map(path -> {
                String filePath = path.toString();
                if (filePath.startsWith(FILE_IN_JAR_PREFIX)) {
                    filePath = filePath.substring(1);
                }
                LOGGER.info("infer runtime file name is {}", (Object)filePath);
                return filePath;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("get infer runtime files error", (Throwable)e);
            throw new GeaflowRuntimeException("get infer runtime files failed", (Throwable)e);
        }
        return runtimeFiles;
    }

    private void prepareInferFiles(InferEnvironmentContext environmentContext) {
        String pythonFilesDirectory = environmentContext.getInferFilesDirectory();
        List<File> modelFile = InferFileUtils.getPythonFilesByCondition(pathname -> {
            String fileName = pathname.getName();
            String fileExtension = FilenameUtils.getExtension((String)fileName);
            return pathname.isFile() && ".pt".equals(fileExtension);
        });
        Preconditions.checkState((!modelFile.isEmpty() ? 1 : 0) != 0, (Object)"model(.pt) file is not exist, please upload model.pt file");
        Preconditions.checkState((modelFile.size() == 1 ? 1 : 0) != 0, (Object)"upload model.pt num more than 1");
        InferFileUtils.copyPythonFile(pythonFilesDirectory, modelFile.get(0), "model.pt");
        List<File> requirementsFile = InferFileUtils.getPythonFilesByCondition(pathname -> {
            String fileName = pathname.getName();
            return pathname.isFile() && fileName.equals("requirements.txt");
        });
        Preconditions.checkState((!requirementsFile.isEmpty() ? 1 : 0) != 0, (Object)"please upload requirements.txt (build infer env) file");
        Preconditions.checkState((requirementsFile.size() == 1 ? 1 : 0) != 0, (Object)"upload requirements.txt num more than 1");
        InferFileUtils.copyPythonFile(environmentContext.getVirtualEnvDirectory(), requirementsFile.get(0));
        List<File> pythonFiles = InferFileUtils.getPythonFilesByCondition(pathname -> {
            String fileName = pathname.getName();
            String fileExtension = FilenameUtils.getExtension((String)fileName);
            return pathname.isFile() && ".py".equals(fileExtension);
        });
        Preconditions.checkState((!pythonFiles.isEmpty() ? 1 : 0) != 0, (Object)"infer files is empty, please upload infer files");
        pythonFiles.forEach(f -> InferFileUtils.copyPythonFile(pythonFilesDirectory, f));
    }
}

