/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.FrameworkConfigKeys;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.infer.InferDependencyManager;
import com.antgroup.geaflow.infer.InferEnvironmentContext;
import com.antgroup.geaflow.infer.util.InferFileUtils;
import com.antgroup.geaflow.infer.util.ShellExecUtils;
import com.google.common.base.Joiner;
import java.io.File;
import java.nio.channels.FileLock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferEnvironmentManager
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InferEnvironmentManager.class);
    private static final String LOCK_FILE = "_lock";
    private static final String SHELL_START = "/bin/sh";
    private static final String FINISH_FILE = "_finish";
    private static final String FAILED_FILE = "_failed";
    private static final String EXEC_POOL_PREFIX = "create-infer-env-";
    private static final String VIRTUAL_ENV_DIR = "inferEnv";
    private static final String INFER_FILES_DIR = "inferFiles";
    private static final AtomicReference<Throwable> ERROR_CASE = new AtomicReference();
    private static final AtomicInteger THREAD_IDX_GENERATOR = new AtomicInteger();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final AtomicBoolean SUCCESS_FLAG = new AtomicBoolean(false);
    private static InferEnvironmentManager INSTANCE;
    private static InferEnvironmentContext environmentContext;
    private final Configuration configuration;
    private final transient ExecutorService executorService;

    public static synchronized InferEnvironmentManager buildInferEnvironmentManager(Configuration config) {
        if (INSTANCE == null) {
            INSTANCE = new InferEnvironmentManager(config);
        }
        return INSTANCE;
    }

    private InferEnvironmentManager(Configuration config) {
        this.configuration = config;
        this.executorService = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r);
            String name = String.format(EXEC_POOL_PREFIX + THREAD_IDX_GENERATOR.getAndIncrement(), new Object[0]);
            t.setName(name);
            t.setDaemon(true);
            return t;
        });
    }

    public void createEnvironment() {
        if (INITIALIZED.compareAndSet(false, true)) {
            this.executorService.execute(() -> {
                try {
                    environmentContext = this.constructInferEnvironment(this.configuration);
                    if (environmentContext.enableFinished().booleanValue()) {
                        SUCCESS_FLAG.set(true);
                        LOGGER.info("{} create infer environment finished", (Object)environmentContext.getRoleNameIndex());
                    }
                }
                catch (Throwable e) {
                    SUCCESS_FLAG.set(false);
                    ERROR_CASE.set(e);
                    LOGGER.error("execute install infer environment error", e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InferEnvironmentContext constructInferEnvironment(Configuration configuration) {
        File failedFile;
        File finishFile;
        FileLock lock;
        InferEnvironmentContext environmentContext;
        block11: {
            block10: {
                String inferEnvDirectory = InferFileUtils.createTargetDir(VIRTUAL_ENV_DIR, configuration);
                String inferFilesDirectory = InferFileUtils.createTargetDir(INFER_FILES_DIR, configuration);
                environmentContext = new InferEnvironmentContext(inferEnvDirectory, inferFilesDirectory, configuration);
                lock = null;
                File lockFile = new File(inferEnvDirectory + File.separator + LOCK_FILE);
                if (!lockFile.exists()) {
                    boolean createLock = lockFile.createNewFile();
                    LOGGER.info("{} create lock file result {}", (Object)environmentContext.getRoleNameIndex(), (Object)createLock);
                }
                lock = InferFileUtils.addLock(lockFile);
                finishFile = new File(inferEnvDirectory + File.separator + FINISH_FILE);
                failedFile = new File(inferEnvDirectory + File.separator + FAILED_FILE);
                if (!failedFile.exists()) break block10;
                environmentContext.setFinished(false);
                LOGGER.warn("{} create infer environment failed", (Object)environmentContext.getRoleNameIndex());
                InferEnvironmentContext inferEnvironmentContext = environmentContext;
                if (lock == null) return inferEnvironmentContext;
                InferFileUtils.releaseLock(lock);
                return inferEnvironmentContext;
            }
            if (!finishFile.exists()) break block11;
            environmentContext.setFinished(true);
            LOGGER.info("{} create infer environment finished", (Object)environmentContext.getRoleNameIndex());
            InferEnvironmentContext inferEnvironmentContext = environmentContext;
            if (lock == null) return inferEnvironmentContext;
            InferFileUtils.releaseLock(lock);
            return inferEnvironmentContext;
        }
        try {
            InferDependencyManager inferDependencyManager = new InferDependencyManager(environmentContext);
            boolean createFinished = this.createInferVirtualEnv(inferDependencyManager, environmentContext.getVirtualEnvDirectory());
            environmentContext.setFinished(createFinished);
            if (!createFinished) {
                failedFile.createNewFile();
                throw new GeaflowRuntimeException("execute virtual env shell failed");
            }
            finishFile.createNewFile();
            if (lock == null) return environmentContext;
        }
        catch (Throwable e) {
            try {
                ERROR_CASE.set(e);
                LOGGER.error("construct infer environment failed", e);
                return environmentContext;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (lock != null) {
                    InferFileUtils.releaseLock(lock);
                }
            }
        }
        InferFileUtils.releaseLock(lock);
        return environmentContext;
    }

    private boolean createInferVirtualEnv(InferDependencyManager dependencyManager, String workingDir) {
        String shellPath = dependencyManager.getBuildInferEnvShellPath();
        ArrayList<String> execParams = new ArrayList<String>();
        String requirementsPath = dependencyManager.getInferEnvRequirementsPath();
        execParams.add(workingDir);
        execParams.add(requirementsPath);
        String conda = this.configuration.getString(FrameworkConfigKeys.INFER_ENV_CONDA_URL);
        execParams.add(conda);
        ArrayList<String> shellCommand = new ArrayList<String>(Arrays.asList(SHELL_START, shellPath));
        shellCommand.addAll(execParams);
        String cmd = Joiner.on((String)" ").join(shellCommand);
        LOGGER.info("create infer virtual env {}", (Object)cmd);
        int installEnvTimeOut = this.configuration.getInteger(FrameworkConfigKeys.INFER_ENV_INIT_TIMEOUT_SEC);
        return ShellExecUtils.run(cmd, Duration.ofSeconds(installEnvTimeOut), arg_0 -> ((Logger)LOGGER).info(arg_0), arg_0 -> ((Logger)LOGGER).error(arg_0), workingDir);
    }

    @Override
    public void close() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public static Boolean checkInferEnvironmentStatus() {
        return SUCCESS_FLAG.get();
    }

    public static InferEnvironmentContext getEnvironmentContext() {
        return environmentContext;
    }

    public static void checkError() {
        Throwable exception = ERROR_CASE.get();
        if (exception != null) {
            String message = "create infer environment failed: " + exception.getMessage();
            LOGGER.error(message);
            throw new GeaflowRuntimeException(message, exception);
        }
    }
}

