/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.FrameworkConfigKeys;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.infer.InferEnvironmentContext;
import com.antgroup.geaflow.infer.InferTaskRun;
import com.antgroup.geaflow.infer.InferTaskStatus;
import com.antgroup.geaflow.infer.log.ProcessLoggerManager;
import com.antgroup.geaflow.infer.log.Slf4JProcessOutputConsumer;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferTaskRunImpl
implements InferTaskRun {
    private static final Logger LOGGER = LoggerFactory.getLogger(InferTaskRunImpl.class);
    private static final File NULL_FILE = new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");
    private static final long TIMEOUT_SECOND = 10L;
    private static final String SCRIPT_SEPARATOR = " ";
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String PATH = "PATH";
    private static final String PATH_REGEX = ":";
    private static final String PYTHON_PATH = "PYTHONPATH";
    private final InferEnvironmentContext inferEnvironmentContext;
    private final Configuration jobConfig;
    private final String virtualEnvPath;
    private final String inferFilePath;
    private final String executePath;
    private Process inferTask;
    private String inferScript;
    private InferTaskStatus inferTaskStatus;

    public InferTaskRunImpl(InferEnvironmentContext inferEnvironmentContext) {
        this.inferEnvironmentContext = inferEnvironmentContext;
        this.jobConfig = inferEnvironmentContext.getJobConfig();
        this.inferFilePath = inferEnvironmentContext.getInferFilesDirectory();
        this.virtualEnvPath = inferEnvironmentContext.getVirtualEnvDirectory();
        this.executePath = this.virtualEnvPath + "/bin";
    }

    @Override
    public void run(List<String> script) {
        this.inferScript = Joiner.on((String)SCRIPT_SEPARATOR).join(script);
        LOGGER.info("infer task run command is {}", (Object)this.inferScript);
        ProcessBuilder inferTaskBuilder = new ProcessBuilder(script);
        this.buildInferTaskBuilder(inferTaskBuilder);
        try {
            this.inferTask = inferTaskBuilder.start();
            this.inferTaskStatus = InferTaskStatus.RUNNING;
            ProcessLoggerManager processLogger = new ProcessLoggerManager(this.inferTask, new Slf4JProcessOutputConsumer(this.getClass().getSimpleName()));
            processLogger.startLogging();
            int exitValue = 0;
            if (this.inferTask.waitFor(10L, TimeUnit.SECONDS)) {
                exitValue = this.inferTask.exitValue();
                this.inferTaskStatus = InferTaskStatus.FAILED;
            } else {
                this.inferTaskStatus = InferTaskStatus.RUNNING;
            }
            if (exitValue != 0) {
                throw new GeaflowRuntimeException(String.format("infer task [%s] run failed, exitCode is %d, message is %s", this.inferScript, exitValue, processLogger.getErrorOutputLogger().get()));
            }
        }
        catch (Exception e) {
            throw new GeaflowRuntimeException("infer task run failed", (Throwable)e);
        }
        finally {
            if (this.inferTask != null && this.inferTaskStatus.equals((Object)InferTaskStatus.FAILED)) {
                this.inferTask.destroyForcibly();
            }
        }
    }

    @Override
    public void stop() {
        if (this.inferTask != null) {
            this.inferTask.destroyForcibly();
        }
    }

    private void buildInferTaskBuilder(ProcessBuilder processBuilder) {
        Map<String, String> environment = processBuilder.environment();
        environment.put(PATH, this.executePath);
        processBuilder.directory(new File(this.inferFilePath));
        processBuilder.redirectErrorStream(true);
        this.setLibraryPath(processBuilder);
        environment.computeIfAbsent(PYTHON_PATH, k -> this.virtualEnvPath);
        processBuilder.redirectOutput(NULL_FILE);
    }

    private void setLibraryPath(ProcessBuilder processBuilder) {
        List<String> userDefineLibPath = this.getUserDefineLibPath();
        StringBuilder libBuilder = new StringBuilder();
        libBuilder.append(this.inferEnvironmentContext.getInferLibPath());
        libBuilder.append(PATH_REGEX);
        for (String ldLibraryPath : userDefineLibPath) {
            libBuilder.append(ldLibraryPath);
            libBuilder.append(PATH_REGEX);
        }
        String ldLibraryPathEnvVar = System.getenv(LD_LIBRARY_PATH);
        libBuilder.append(ldLibraryPathEnvVar);
        processBuilder.environment().put(LD_LIBRARY_PATH, libBuilder.toString());
    }

    private List<String> getUserDefineLibPath() {
        String userLibPath = this.jobConfig.getString(FrameworkConfigKeys.INFER_USER_DEFINE_LIB_PATH.getKey());
        ArrayList<String> result = new ArrayList<String>();
        if (userLibPath != null) {
            String[] libs = userLibPath.split(",");
            Iterator iterator = Arrays.stream(libs).iterator();
            while (iterator.hasNext()) {
                String libPath = this.inferFilePath + File.separator + ((String)iterator.next()).trim();
                LOGGER.info("define infer lib path is {}", (Object)libPath);
                result.add(libPath);
            }
        }
        return result;
    }
}

