/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.exchange;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.FrameworkConfigKeys;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.infer.exchange.DataExchangeQueue;
import com.antgroup.geaflow.infer.exchange.UnSafeUtils;
import com.antgroup.geaflow.infer.util.InferFileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class DataExchangeContext
implements Closeable {
    private static final String FILE_KEY_PREFIX = "queue-";
    private static final int INT_SIZE = 4;
    private static final String MMAP_KEY_PREFIX = "queue://";
    private static final String SHARE_MEMORY_DIR = "/infer_data";
    private static final String KEY_SEPARATOR = ":";
    private static final String MMAP_INPUT_KEY_SUFFIX = ".input";
    private static final String MMAP_OUTPUT_KEY_SUFFIX = ".output";
    private final File localDirectory;
    private final long queueEndpoint;
    private final DataExchangeQueue receiveQueue;
    private final DataExchangeQueue sendQueue;
    private final File receiveQueueFile;
    private final File sendQueueFile;
    private String receivePath;
    private String sendPath;

    public DataExchangeContext(Configuration config) {
        this.localDirectory = new File(InferFileUtils.getInferDirectory(config) + SHARE_MEMORY_DIR);
        this.queueEndpoint = UnSafeUtils.UNSAFE.allocateMemory(4L);
        UnSafeUtils.UNSAFE.setMemory(this.queueEndpoint, 4L, (byte)0);
        this.receiveQueueFile = this.createTempFile(FILE_KEY_PREFIX, MMAP_INPUT_KEY_SUFFIX);
        this.sendQueueFile = this.createTempFile(FILE_KEY_PREFIX, MMAP_OUTPUT_KEY_SUFFIX);
        this.receivePath = this.receiveQueueFile.getAbsolutePath();
        this.sendPath = this.sendQueueFile.getAbsolutePath();
        int queueCapacity = config.getInteger(FrameworkConfigKeys.INFER_ENV_SHARE_MEMORY_QUEUE_SIZE);
        this.receiveQueue = new DataExchangeQueue(this.receivePath, queueCapacity, true);
        this.sendQueue = new DataExchangeQueue(this.sendPath, queueCapacity, true);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> UnSafeUtils.UNSAFE.freeMemory(this.queueEndpoint)));
    }

    public String getReceiveQueueKey() {
        return MMAP_KEY_PREFIX + this.receivePath + KEY_SEPARATOR + this.receiveQueue.getMemoryMapSize();
    }

    public String getSendQueueKey() {
        return MMAP_KEY_PREFIX + this.sendPath + KEY_SEPARATOR + this.sendQueue.getMemoryMapSize();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.receiveQueue != null) {
            this.receiveQueue.close();
        }
        if (this.sendQueue != null) {
            this.sendQueue.close();
        }
        if (this.receiveQueueFile != null) {
            this.receiveQueueFile.delete();
        }
        if (this.sendQueueFile != null) {
            this.sendQueueFile.delete();
        }
        UnSafeUtils.UNSAFE.freeMemory(this.queueEndpoint);
        FileUtils.deleteQuietly((File)this.localDirectory);
    }

    public DataExchangeQueue getReceiveQueue() {
        return this.receiveQueue;
    }

    public DataExchangeQueue getSendQueue() {
        return this.sendQueue;
    }

    private File createTempFile(String prefix, String suffix) {
        try {
            if (!this.localDirectory.exists()) {
                InferFileUtils.forceMkdir(this.localDirectory);
            }
            return File.createTempFile(prefix, suffix, this.localDirectory);
        }
        catch (IOException e) {
            throw new GeaflowRuntimeException("create temp file on infer directory failed ", (Throwable)e);
        }
    }
}

