/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.exchange;

import com.antgroup.geaflow.infer.exchange.MemoryMapper;
import com.antgroup.geaflow.infer.exchange.UnSafeUtils;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jctools.util.PortableJvmInfo;
import org.jctools.util.Pow2;

public final class DataExchangeQueue
implements Closeable {
    private static final AtomicBoolean CLOSED = new AtomicBoolean(false);
    private final long outputNextAddress;
    private final long capacityAddress;
    private final long outputAddress;
    private final long inputNextAddress;
    private final long barrierAddress;
    private final long currentBufferAddress;
    private final long mapAddress;
    private final int queueCapacity;
    private final int bufferCapacity;
    private final long initialRawAddress;
    private final long startPointAddress;
    private final long endPointAddress;
    private final MemoryMapper memoryMapper;

    public DataExchangeQueue(String mapKey, int capacity, boolean reset) {
        this.bufferCapacity = this.getBufferCapacity(capacity);
        this.memoryMapper = new MemoryMapper(mapKey, this.bufferCapacity + PortableJvmInfo.CACHE_LINE_SIZE);
        this.mapAddress = this.memoryMapper.getMapAddress();
        this.queueCapacity = Pow2.roundToPowerOfTwo((int)capacity);
        this.startPointAddress = this.initialRawAddress = Pow2.align((long)this.mapAddress, (int)PortableJvmInfo.CACHE_LINE_SIZE);
        this.capacityAddress = this.startPointAddress + (long)PortableJvmInfo.CACHE_LINE_SIZE;
        this.outputAddress = this.startPointAddress + 2L * (long)PortableJvmInfo.CACHE_LINE_SIZE;
        this.inputNextAddress = this.outputAddress + 8L;
        this.outputNextAddress = this.startPointAddress + 8L;
        this.endPointAddress = this.outputAddress + (long)PortableJvmInfo.CACHE_LINE_SIZE;
        this.barrierAddress = this.endPointAddress + 8L;
        this.currentBufferAddress = this.barrierAddress + 8L;
        if (reset) {
            this.reset();
        }
    }

    @Override
    public synchronized void close() {
        CLOSED.set(true);
        if (this.memoryMapper != null) {
            this.memoryMapper.close();
        }
        UnSafeUtils.UNSAFE.freeMemory(this.mapAddress);
    }

    public long getMemoryMapSize() {
        if (this.memoryMapper == null) {
            return 0L;
        }
        return this.memoryMapper.getMapSize();
    }

    public long getInputPointer() {
        return UnSafeUtils.UNSAFE.getLong(null, this.startPointAddress);
    }

    public long getInputPointerByVolatile() {
        return UnSafeUtils.UNSAFE.getLongVolatile(null, this.startPointAddress);
    }

    public void setInputPointer(long value) {
        UnSafeUtils.UNSAFE.putOrderedLong(null, this.startPointAddress, value);
    }

    public long getOutputPointer() {
        return UnSafeUtils.UNSAFE.getLong(null, this.outputAddress);
    }

    public long getOutputPointerByVolatile() {
        return UnSafeUtils.UNSAFE.getLongVolatile(null, this.outputAddress);
    }

    public void setOutputPointer(long value) {
        UnSafeUtils.UNSAFE.putOrderedLong(null, this.outputAddress, value);
    }

    public long getInputNextPointer() {
        return UnSafeUtils.UNSAFE.getLong(null, this.inputNextAddress);
    }

    public void setInputNextPointer(long value) {
        UnSafeUtils.UNSAFE.putLong(this.inputNextAddress, value);
    }

    public long getOutputNextPointer() {
        return UnSafeUtils.UNSAFE.getLong(null, this.outputNextAddress);
    }

    public void setOutputNextPointer(long value) {
        UnSafeUtils.UNSAFE.putLong(this.outputNextAddress, value);
    }

    public long getBarrierAddress() {
        return UnSafeUtils.UNSAFE.getLong(this.barrierAddress);
    }

    public long getCurrentBufferAddress() {
        return UnSafeUtils.UNSAFE.getLong(this.currentBufferAddress);
    }

    public boolean enableFinished() {
        return UnSafeUtils.UNSAFE.getLongVolatile(null, this.endPointAddress) != 0L;
    }

    public synchronized void markFinished() {
        if (!CLOSED.get()) {
            UnSafeUtils.UNSAFE.putOrderedLong(null, this.endPointAddress, -1L);
        }
    }

    public long getInitialQueueAddress() {
        return this.initialRawAddress + 4L * (long)PortableJvmInfo.CACHE_LINE_SIZE;
    }

    public int getQueueMask() {
        return this.queueCapacity - 1;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getBufferCapacity(int capacity) {
        return Pow2.roundToPowerOfTwo((int)capacity) + 4 * PortableJvmInfo.CACHE_LINE_SIZE;
    }

    public void reset() {
        UnSafeUtils.UNSAFE.setMemory(this.initialRawAddress, this.bufferCapacity, (byte)0);
        UnSafeUtils.UNSAFE.putLongVolatile(null, this.capacityAddress, this.queueCapacity);
    }

    public static long getNextPointIndex(long v, int capacity) {
        if ((v & (long)(capacity - 1)) == 0L) {
            return v + (long)capacity;
        }
        return Pow2.align((long)v, (int)capacity);
    }
}

