/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.exchange;

import com.antgroup.geaflow.infer.exchange.DataExchangeQueue;
import com.antgroup.geaflow.infer.exchange.DataQueueInputStream;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferDataReader
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InferDataReader.class);
    private static final AtomicBoolean END = new AtomicBoolean(false);
    private static final int HEADER_LENGTH = 4;
    private final DataInputStream input;

    public InferDataReader(DataExchangeQueue dataExchangeQueue) {
        DataQueueInputStream dataQueueInputStream = new DataQueueInputStream(dataExchangeQueue);
        this.input = new DataInputStream(dataQueueInputStream);
    }

    public byte[] read() throws IOException {
        int bytesNum;
        byte[] buffer = new byte[4];
        try {
            bytesNum = this.input.read(buffer);
        }
        catch (EOFException e) {
            LOGGER.error("read infer data fail", (Throwable)e);
            END.set(true);
            return null;
        }
        if (bytesNum < 0) {
            LOGGER.warn("read infer data size is {}", (Object)bytesNum);
            END.set(true);
            return null;
        }
        if (bytesNum < buffer.length) {
            this.input.readFully(buffer, bytesNum, buffer.length - bytesNum);
        }
        int len = this.fromInt32LE(buffer);
        byte[] data = new byte[len];
        this.input.readFully(data);
        return data;
    }

    private int fromInt32LE(byte[] data) {
        Preconditions.checkState((data.length == 4 ? 1 : 0) != 0, (Object)String.format("read data header size %d, must be %d", data.length, 4));
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getInt();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

