/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.exchange;

import com.antgroup.geaflow.infer.exchange.DataExchangeQueue;
import com.antgroup.geaflow.infer.exchange.DataQueueOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class InferDataWriter
implements Closeable {
    private static final int HEADER_LENGTH = 4;
    private final DataQueueOutputStream outputStream;
    private final byte[] dataHeaderBytes;
    private final ByteBuffer headerByteBuffer;

    public InferDataWriter(DataExchangeQueue dataExchangeQueue) {
        this.outputStream = new DataQueueOutputStream(dataExchangeQueue);
        this.dataHeaderBytes = new byte[4];
        this.headerByteBuffer = ByteBuffer.wrap(this.dataHeaderBytes);
        this.headerByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public boolean write(byte[] record, int offset, int length) throws IOException {
        int outputSize = 4 + (length - offset);
        if (!this.outputStream.tryReserveBeforeWrite(outputSize)) {
            return false;
        }
        byte[] headerData = this.extractHeaderData(length);
        this.outputStream.write(headerData, 0, 4);
        this.outputStream.write(record, offset, length);
        return true;
    }

    public boolean write(byte[] record) throws IOException {
        return this.write(record, 0, record.length);
    }

    private byte[] extractHeaderData(int data) {
        this.headerByteBuffer.clear();
        this.headerByteBuffer.putInt(data);
        return this.dataHeaderBytes;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

