/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.exchange;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import java.io.Closeable;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.FileChannelImpl;

public class MemoryMapper
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryMapper.class);
    private static final String MAP_0 = "map0";
    private static final String UNMAP_0 = "unmap0";
    private static final Method MEMORY_MAP_METHOD;
    private static final String SHARE_MEMORY_MODE = "rw";
    private static final Method MEMORY_UN_MAP_METHOD;
    private long mapAddress;
    private final long mapSize;
    private final String mapKey;

    public MemoryMapper(String mapKey, long size) {
        this.mapKey = mapKey;
        this.mapSize = this.roundTo4096(size);
        this.map(mapKey, this.mapSize);
    }

    private void map(String mapKey, long mapSize) {
        try {
            RandomAccessFile backingFile = new RandomAccessFile(mapKey, SHARE_MEMORY_MODE);
            backingFile.setLength(mapSize);
            FileChannel ch = backingFile.getChannel();
            this.mapAddress = (Long)MEMORY_MAP_METHOD.invoke((Object)ch, 1, 0L, mapSize);
            ch.close();
            backingFile.close();
        }
        catch (Throwable e) {
            LOGGER.error("map memory key {} size {} failed", (Object)mapKey, (Object)mapSize);
            throw new GeaflowRuntimeException("memory map failed", e);
        }
    }

    public void unMap() {
        if (this.mapAddress != 0L) {
            try {
                MEMORY_UN_MAP_METHOD.invoke(null, this.mapAddress, this.mapSize);
            }
            catch (Throwable e) {
                LOGGER.error("un map error");
                this.mapAddress = 0L;
            }
        }
        this.mapAddress = 0L;
    }

    @Override
    public void close() {
        this.unMap();
    }

    public long getMapSize() {
        return this.mapSize;
    }

    public long getMapAddress() {
        return this.mapAddress;
    }

    private static Method getMethod(Class<?> cls, String name, Class<?> ... params) throws Exception {
        Method m = cls.getDeclaredMethod(name, params);
        m.setAccessible(true);
        return m;
    }

    private long roundTo4096(long i) {
        return i + 4095L & 0xFFFFFFFFFFFFF000L;
    }

    static {
        try {
            MEMORY_MAP_METHOD = MemoryMapper.getMethod(FileChannelImpl.class, MAP_0, Integer.TYPE, Long.TYPE, Long.TYPE);
            MEMORY_UN_MAP_METHOD = MemoryMapper.getMethod(FileChannelImpl.class, UNMAP_0, Long.TYPE, Long.TYPE);
        }
        catch (Exception e) {
            throw new GeaflowRuntimeException((Throwable)e);
        }
    }
}

