/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.exchange.impl;

import com.antgroup.geaflow.infer.exchange.DataExchangeContext;
import com.antgroup.geaflow.infer.exchange.DataExchangeQueue;
import com.antgroup.geaflow.infer.exchange.IDataBridge;
import com.antgroup.geaflow.infer.exchange.IDecoder;
import com.antgroup.geaflow.infer.exchange.IEncoder;
import com.antgroup.geaflow.infer.exchange.InferDataReader;
import com.antgroup.geaflow.infer.exchange.InferDataWriter;
import com.antgroup.geaflow.infer.exchange.impl.DataExchangeDeCoderImpl;
import com.antgroup.geaflow.infer.exchange.impl.DataExchangeEnCoderImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class InferDataBridgeImpl<OUT>
implements IDataBridge<OUT> {
    private static final int HEADER_LENGTH = 4;
    private final byte[] bufferArray;
    private final ByteBuffer byteBuffer;
    private final InferDataWriter inferDataWriter;
    private final InferDataReader inferDataReader;
    private final IEncoder encoder;
    private final IDecoder<OUT> decoder;

    public InferDataBridgeImpl(DataExchangeContext shareMemoryContext) {
        DataExchangeQueue receiveQueue = shareMemoryContext.getReceiveQueue();
        DataExchangeQueue sendQueue = shareMemoryContext.getSendQueue();
        this.inferDataReader = new InferDataReader(receiveQueue);
        this.inferDataWriter = new InferDataWriter(sendQueue);
        this.encoder = new DataExchangeEnCoderImpl();
        this.decoder = new DataExchangeDeCoderImpl<OUT>();
        this.bufferArray = new byte[4];
        this.byteBuffer = ByteBuffer.wrap(this.bufferArray);
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public boolean write(Object ... inputs) throws IOException {
        int inputsSize = inputs.length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] dataSizeBytes = this.toInt32LE(inputsSize);
        result.write(dataSizeBytes);
        for (Object element : inputs) {
            result.write(this.transformBytes(element));
        }
        byte[] byteArray = result.toByteArray();
        return this.inferDataWriter.write(byteArray);
    }

    @Override
    public OUT read() throws IOException {
        byte[] result = this.inferDataReader.read();
        if (result != null) {
            return this.decoder.decode(result);
        }
        return null;
    }

    private byte[] transformBytes(Object obj) {
        byte[] dataBytes = this.encoder.encode(obj);
        int dataLength = dataBytes.length;
        byte[] lenBytes = this.toInt32LE(dataLength);
        ByteBuffer buffer = ByteBuffer.allocate(4 + dataLength);
        buffer.put(lenBytes);
        buffer.put(dataBytes);
        return buffer.array();
    }

    private byte[] toInt32LE(int data) {
        this.byteBuffer.clear();
        this.byteBuffer.putInt(data);
        return this.bufferArray;
    }

    @Override
    public void close() throws IOException {
        this.inferDataReader.close();
        this.inferDataWriter.close();
        this.encoder.close();
        this.decoder.close();
    }
}

