/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.exchange.serialize;

import com.antgroup.geaflow.infer.exchange.serialize.IObjectConstructor;
import com.antgroup.geaflow.infer.exchange.serialize.PickleException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class ByteArrayConstructor
implements IObjectConstructor {
    private static final String LATIN = "latin-";
    private static final String ISO_KEY = "ISO-8859-";

    @Override
    public Object construct(Object[] args) throws PickleException {
        if (args.length > 2) {
            throw new PickleException("invalid pickle data for bytearray; expected 0, 1 or 2 args, got " + args.length);
        }
        if (args.length == 0) {
            return new byte[0];
        }
        if (args.length == 1) {
            if (args[0] instanceof byte[]) {
                return args[0];
            }
            ArrayList values = (ArrayList)args[0];
            byte[] data = new byte[values.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = ((Number)values.get(i)).byteValue();
            }
            return data;
        }
        String data = (String)args[0];
        String encoding = (String)args[1];
        if (encoding.startsWith(LATIN)) {
            encoding = ISO_KEY + encoding.substring(6);
        }
        try {
            return data.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new PickleException("error creating bytearray: " + e);
        }
    }
}

