/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.exchange.serialize;

import java.io.Serializable;

public class ComplexNumber
implements Serializable {
    private static final long serialVersionUID = 4668080260997226513L;
    private static final String ADD_FLAG = "+";
    private static final String I_FLAG = "i";
    private final double r;
    private final double i;

    public ComplexNumber(double rr, double ii) {
        this.r = rr;
        this.i = ii;
    }

    public ComplexNumber(Double rr, Double ii) {
        this.r = rr;
        this.i = ii;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append(this.r);
        if (this.i >= 0.0) {
            sb.append(ADD_FLAG);
        }
        return sb.append(this.i).append(I_FLAG).toString();
    }

    public double getReal() {
        return this.r;
    }

    public double getImaginary() {
        return this.i;
    }

    public double magnitude() {
        return Math.sqrt(this.r * this.r + this.i * this.i);
    }

    public ComplexNumber add(ComplexNumber other) {
        return ComplexNumber.add(this, other);
    }

    public static ComplexNumber add(ComplexNumber c1, ComplexNumber c2) {
        return new ComplexNumber(c1.r + c2.r, c1.i + c2.i);
    }

    public ComplexNumber subtract(ComplexNumber other) {
        return ComplexNumber.subtract(this, other);
    }

    public static ComplexNumber subtract(ComplexNumber c1, ComplexNumber c2) {
        return new ComplexNumber(c1.r - c2.r, c1.i - c2.i);
    }

    public ComplexNumber multiply(ComplexNumber other) {
        return ComplexNumber.multiply(this, other);
    }

    public static ComplexNumber multiply(ComplexNumber c1, ComplexNumber c2) {
        return new ComplexNumber(c1.r * c2.r - c1.i * c2.i, c1.r * c2.i + c1.i * c2.r);
    }

    public static ComplexNumber divide(ComplexNumber c1, ComplexNumber c2) {
        double value = c2.r * c2.r + c2.i * c2.i;
        return new ComplexNumber((c1.r * c2.r + c1.i * c2.i) / value, (c1.i * c2.r - c1.r * c2.i) / value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ComplexNumber)) {
            return false;
        }
        ComplexNumber other = (ComplexNumber)o;
        return this.r == other.r && this.i == other.i;
    }

    public int hashCode() {
        return Double.valueOf(this.r).hashCode() ^ Double.valueOf(this.i).hashCode();
    }
}

