/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.exchange.serialize;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.infer.exchange.serialize.IObjectConstructor;
import com.antgroup.geaflow.infer.exchange.serialize.PickleException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class ExceptionConstructor
implements IObjectConstructor {
    private static final String PYTHON_EXCEPTION_TYPE = "pythonExceptionType";
    private static final String MODULE_SUFFIX = ".";
    private static final String BRACKETS_LEFT = "[";
    private static final String BRACKETS_RIGHT = "]";
    private final Class<?> type;
    private final String pythonExceptionType;

    public ExceptionConstructor(Class<?> type, String module, String name) {
        this.pythonExceptionType = module != null ? module + MODULE_SUFFIX + name : name;
        this.type = type;
    }

    @Override
    public Object construct(Object[] args) {
        try {
            if (this.pythonExceptionType != null) {
                if (args == null || args.length == 0) {
                    args = new String[]{BRACKETS_LEFT + this.pythonExceptionType + BRACKETS_RIGHT};
                } else {
                    String msg = BRACKETS_LEFT + this.pythonExceptionType + BRACKETS_RIGHT + args[0];
                    args = new String[]{msg};
                }
            }
            Class[] paramTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                paramTypes[i] = args[i].getClass();
            }
            Constructor<?> cons = this.type.getConstructor(paramTypes);
            Object ex = cons.newInstance(args);
            try {
                Field prop = ex.getClass().getField(PYTHON_EXCEPTION_TYPE);
                prop.set(ex, this.pythonExceptionType);
            }
            catch (NoSuchFieldException e) {
                throw new GeaflowRuntimeException((Throwable)e);
            }
            return ex;
        }
        catch (Exception x) {
            throw new PickleException("problem construction object: " + x);
        }
    }
}

