/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.exchange.serialize;

import com.antgroup.geaflow.infer.exchange.serialize.IObjectPickler;
import com.antgroup.geaflow.infer.exchange.serialize.PickleException;
import com.antgroup.geaflow.infer.exchange.serialize.PickleUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Pickler {
    private static final String GET = "get";
    private static final String GET_CLASS = "getClass";
    private static final String IS = "is";
    private static final String CLASS_KEY = "__class__";
    private static final int PROTOCOL = 2;
    private static final int MAX_RECURSE_DEPTH = 1000;
    private int recurse = 0;
    private OutputStream out;
    private static final Map<Class<?>, IObjectPickler> CUSTOM_PICKLER = new HashMap();
    private final boolean useMemo;
    private final boolean valueCompare;
    protected HashMap<Integer, Memo> memo;

    public Pickler() {
        this(true);
    }

    public Pickler(boolean useMemo) {
        this(useMemo, true);
    }

    public Pickler(boolean useMemo, boolean valueCompare) {
        this.useMemo = useMemo;
        this.valueCompare = valueCompare;
    }

    public void close() throws IOException {
        this.memo = null;
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
    }

    public static synchronized void registerCustomPickler(Class<?> clazz, IObjectPickler pickler) {
        CUSTOM_PICKLER.put(clazz, pickler);
    }

    public byte[] dumps(Object o) throws PickleException, IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        this.dump(o, bo);
        bo.flush();
        return bo.toByteArray();
    }

    public void dump(Object o, OutputStream stream) throws IOException, PickleException {
        this.out = stream;
        this.recurse = 0;
        if (this.useMemo) {
            this.memo = new HashMap();
        }
        this.out.write(128);
        this.out.write(2);
        this.save(o);
        this.memo = null;
        this.out.write(46);
        this.out.flush();
        if (this.recurse != 0) {
            throw new PickleException("recursive structure error, please report this problem");
        }
    }

    public void save(Object o) throws PickleException, IOException {
        ++this.recurse;
        if (this.recurse > 1000) {
            throw new StackOverflowError("recursion too deep in Pickler.save (>1000)");
        }
        if (o == null) {
            this.out.write(78);
            --this.recurse;
            return;
        }
        Class<?> t = o.getClass();
        if (this.lookupMemo(t, o) || this.dispatch(t, o)) {
            --this.recurse;
            return;
        }
        throw new PickleException("couldn't pickle object of type " + t);
    }

    protected void writeMemo(Object obj) throws IOException {
        int hash;
        if (!this.useMemo) {
            return;
        }
        int n = hash = this.valueCompare ? obj.hashCode() : System.identityHashCode(obj);
        if (!this.memo.containsKey(hash)) {
            int memoIndex = this.memo.size();
            this.memo.put(hash, new Memo(obj, memoIndex));
            if (memoIndex <= 255) {
                this.out.write(113);
                this.out.write((byte)memoIndex);
            } else {
                this.out.write(114);
                byte[] indexBytes = PickleUtils.integer2Bytes(memoIndex);
                this.out.write(indexBytes, 0, 4);
            }
        }
    }

    private boolean lookupMemo(Class<?> objectType, Object obj) throws IOException {
        if (!this.useMemo) {
            return false;
        }
        if (!objectType.isPrimitive()) {
            int hash;
            int n = hash = this.valueCompare ? obj.hashCode() : System.identityHashCode(obj);
            if (this.memo.containsKey(hash) && (this.valueCompare ? this.memo.get((Object)Integer.valueOf((int)hash)).obj.equals(obj) : this.memo.get((Object)Integer.valueOf((int)hash)).obj == obj)) {
                int memoIndex = this.memo.get((Object)Integer.valueOf((int)hash)).index;
                if (memoIndex <= 255) {
                    this.out.write(104);
                    this.out.write((byte)memoIndex);
                } else {
                    this.out.write(106);
                    byte[] indexBytes = PickleUtils.integer2Bytes(memoIndex);
                    this.out.write(indexBytes, 0, 4);
                }
                return true;
            }
        }
        return false;
    }

    private boolean dispatch(Class<?> t, Object o) throws IOException {
        Class<?> componentType = t.getComponentType();
        if (componentType != null) {
            if (componentType.isPrimitive()) {
                this.putArrayOfPrimitives(componentType, o);
            } else {
                this.putArrayOfObjects((Object[])o);
            }
            return true;
        }
        if (o instanceof Boolean || t.equals(Boolean.TYPE)) {
            this.putBool((Boolean)o);
            return true;
        }
        if (o instanceof Byte || t.equals(Byte.TYPE)) {
            this.putLong(((Byte)o).longValue());
            return true;
        }
        if (o instanceof Short || t.equals(Short.TYPE)) {
            this.putLong(((Short)o).longValue());
            return true;
        }
        if (o instanceof Integer || t.equals(Integer.TYPE)) {
            this.putLong(((Integer)o).longValue());
            return true;
        }
        if (o instanceof Long || t.equals(Long.TYPE)) {
            this.putLong((Long)o);
            return true;
        }
        if (o instanceof Float || t.equals(Float.TYPE)) {
            this.putFloat(((Float)o).doubleValue());
            return true;
        }
        if (o instanceof Double || t.equals(Double.TYPE)) {
            this.putFloat((Double)o);
            return true;
        }
        if (o instanceof Character || t.equals(Character.TYPE)) {
            this.putString("" + o);
            return true;
        }
        IObjectPickler customPickler = this.getCustomPickler(t);
        if (customPickler != null) {
            customPickler.pickle(o, this.out, this);
            this.writeMemo(o);
            return true;
        }
        if (o instanceof String) {
            this.putString((String)o);
            return true;
        }
        if (o instanceof BigInteger) {
            this.putBigint((BigInteger)o);
            return true;
        }
        if (o instanceof BigDecimal) {
            this.putDecimal((BigDecimal)o);
            return true;
        }
        if (o instanceof Enum) {
            this.putString(o.toString());
            return true;
        }
        if (o instanceof Set) {
            this.putSet((Set)o);
            return true;
        }
        if (o instanceof Map) {
            this.putMap((Map)o);
            return true;
        }
        if (o instanceof List) {
            this.putCollection((List)o);
            return true;
        }
        if (o instanceof Collection) {
            this.putCollection((Collection)o);
            return true;
        }
        if (o instanceof Serializable) {
            this.putJavabean(o);
            return true;
        }
        return false;
    }

    private synchronized IObjectPickler getCustomPickler(Class<?> t) {
        IObjectPickler pickler = CUSTOM_PICKLER.get(t);
        if (pickler != null) {
            return pickler;
        }
        for (Map.Entry<Class<?>, IObjectPickler> x : CUSTOM_PICKLER.entrySet()) {
            if (!x.getKey().isAssignableFrom(t)) continue;
            return x.getValue();
        }
        return null;
    }

    private void putCollection(Collection<?> list) throws IOException {
        this.out.write(93);
        this.writeMemo(list);
        this.out.write(40);
        for (Object o : list) {
            this.save(o);
        }
        this.out.write(101);
    }

    private void putMap(Map<?, ?> o) throws IOException {
        this.out.write(125);
        this.writeMemo(o);
        this.out.write(40);
        for (Object k : o.keySet()) {
            this.save(k);
            this.save(o.get(k));
        }
        this.out.write(117);
    }

    private void putSet(Set<?> o) throws IOException {
        this.out.write(99);
        this.out.write("__builtin__\nset\n".getBytes());
        this.out.write(93);
        this.out.write(40);
        for (Object x : o) {
            this.save(x);
        }
        this.out.write(101);
        this.out.write(133);
        this.out.write(82);
        this.writeMemo(o);
    }

    private void putArrayOfObjects(Object[] array) throws IOException {
        if (array.length == 0) {
            this.out.write(41);
        } else if (array.length == 1) {
            if (array[0] == array) {
                throw new PickleException("recursive array not supported, use list");
            }
            this.save(array[0]);
            this.out.write(133);
        } else if (array.length == 2) {
            if (array[0] == array || array[1] == array) {
                throw new PickleException("recursive array not supported, use list");
            }
            this.save(array[0]);
            this.save(array[1]);
            this.out.write(134);
        } else if (array.length == 3) {
            if (array[0] == array || array[1] == array || array[2] == array) {
                throw new PickleException("recursive array not supported, use list");
            }
            this.save(array[0]);
            this.save(array[1]);
            this.save(array[2]);
            this.out.write(135);
        } else {
            this.out.write(40);
            for (Object o : array) {
                if (o == array) {
                    throw new PickleException("recursive array not supported, use list");
                }
                this.save(o);
            }
            this.out.write(116);
        }
        this.writeMemo(array);
    }

    private void putArrayOfPrimitives(Class<?> t, Object array) throws IOException {
        if (t.equals(Boolean.TYPE)) {
            boolean[] source = (boolean[])array;
            Object[] boolArray = new Boolean[source.length];
            for (int i = 0; i < source.length; ++i) {
                boolArray[i] = source[i];
            }
            this.putArrayOfObjects(boolArray);
            return;
        }
        if (t.equals(Character.TYPE)) {
            String s = new String((char[])array);
            this.putString(s);
            return;
        }
        if (t.equals(Byte.TYPE)) {
            this.out.write(99);
            this.out.write("__builtin__\nbytearray\n".getBytes());
            String str = PickleUtils.rawStringFromBytes((byte[])array);
            this.putString(str);
            this.putString("latin-1");
            this.out.write(134);
            this.out.write(82);
            this.writeMemo(array);
            return;
        }
        this.out.write(99);
        this.out.write("array\narray\n".getBytes());
        this.out.write(85);
        this.out.write(1);
        if (t.equals(Short.TYPE)) {
            this.out.write(104);
            this.out.write(93);
            this.out.write(40);
            for (short s : (short[])array) {
                this.save(s);
            }
        } else if (t.equals(Integer.TYPE)) {
            this.out.write(105);
            this.out.write(93);
            this.out.write(40);
            for (int i : (int[])array) {
                this.save(i);
            }
        } else if (t.equals(Long.TYPE)) {
            this.out.write(108);
            this.out.write(93);
            this.out.write(40);
            for (long v : (long[])array) {
                this.save(v);
            }
        } else if (t.equals(Float.TYPE)) {
            this.out.write(102);
            this.out.write(93);
            this.out.write(40);
            for (float f : (float[])array) {
                this.save(Float.valueOf(f));
            }
        } else if (t.equals(Double.TYPE)) {
            this.out.write(100);
            this.out.write(93);
            this.out.write(40);
            for (double d : (double[])array) {
                this.save(d);
            }
        }
        this.out.write(101);
        this.out.write(134);
        this.out.write(82);
        this.writeMemo(array);
    }

    private void putDecimal(BigDecimal d) throws IOException {
        this.out.write(99);
        this.out.write("decimal\nDecimal\n".getBytes());
        this.putString(d.toEngineeringString());
        this.out.write(133);
        this.out.write(82);
        this.writeMemo(d);
    }

    private void putBigint(BigInteger i) throws IOException {
        byte[] b = PickleUtils.encodeLong(i);
        if (b.length <= 255) {
            this.out.write(138);
            this.out.write(b.length);
            this.out.write(b);
        } else {
            this.out.write(139);
            this.out.write(PickleUtils.integer2Bytes(b.length));
            this.out.write(b);
        }
        this.writeMemo(i);
    }

    private void putString(String string) throws IOException {
        byte[] encoded = string.getBytes(StandardCharsets.UTF_8);
        this.out.write(88);
        this.out.write(PickleUtils.integer2Bytes(encoded.length));
        this.out.write(encoded);
        this.writeMemo(string);
    }

    private void putFloat(double d) throws IOException {
        this.out.write(71);
        this.out.write(PickleUtils.double2Bytes(d));
    }

    private void putLong(long v) throws IOException {
        long highBits;
        if (v >= 0L) {
            if (v <= 255L) {
                this.out.write(75);
                this.out.write((int)v);
                return;
            }
            if (v <= 65535L) {
                this.out.write(77);
                this.out.write((int)v & 0xFF);
                this.out.write((int)v >> 8);
                return;
            }
        }
        if ((highBits = v >> 31) == 0L || highBits == -1L) {
            this.out.write(74);
            this.out.write(PickleUtils.integer2Bytes((int)v));
            return;
        }
        this.putBigint(BigInteger.valueOf(v));
    }

    private void putBool(boolean b) throws IOException {
        if (b) {
            this.out.write(136);
        } else {
            this.out.write(137);
        }
    }

    private void putJavabean(Object o) throws PickleException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            for (Method m : o.getClass().getMethods()) {
                int prefixLen;
                String methodName;
                int modifiers = m.getModifiers();
                if ((modifiers & 1) == 0 || (modifiers & 8) != 0 || (methodName = m.getName()).equals(GET_CLASS)) continue;
                if (methodName.startsWith(GET)) {
                    prefixLen = 3;
                } else {
                    if (!methodName.startsWith(IS)) continue;
                    prefixLen = 2;
                }
                Object value = m.invoke(o, new Object[0]);
                String name = methodName.substring(prefixLen);
                if (name.length() == 1) {
                    name = name.toLowerCase();
                } else if (!Character.isUpperCase(name.charAt(1))) {
                    name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                }
                map.put(name, value);
            }
            map.put(CLASS_KEY, o.getClass().getName());
            this.save(map);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new PickleException("couldn't introspect javabean: " + e);
        }
    }

    private static class Memo {
        public Object obj;
        public int index;

        public Memo(Object obj, int index) {
            this.obj = obj;
            this.index = index;
        }
    }
}

