/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.exchange.serialize;

import com.antgroup.geaflow.infer.exchange.serialize.ArrayConstructor;
import com.antgroup.geaflow.infer.exchange.serialize.ByteArrayConstructor;
import com.antgroup.geaflow.infer.exchange.serialize.ComplexNumberConstructor;
import com.antgroup.geaflow.infer.exchange.serialize.DictionaryConstructor;
import com.antgroup.geaflow.infer.exchange.serialize.ExceptionConstructor;
import com.antgroup.geaflow.infer.exchange.serialize.IObjectConstructor;
import com.antgroup.geaflow.infer.exchange.serialize.InvalidOpcodeException;
import com.antgroup.geaflow.infer.exchange.serialize.PickleException;
import com.antgroup.geaflow.infer.exchange.serialize.PickleUtils;
import com.antgroup.geaflow.infer.exchange.serialize.PythonException;
import com.antgroup.geaflow.infer.exchange.serialize.UnpickleStack;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unpickler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Unpickler.class);
    private static final String SET_STATE = "setState";
    private static final String PYTHON_EXCEPTION = "python_exception";
    private static final String MODULE_SUFFIX = ".";
    private static final String LONG_END_WITH = "L";
    private static final String EXCEPTIONS = "exceptions";
    private static final String ERROR = "Error";
    private static final String EXCEPTION = "Exception";
    private static final String WARNING = "Warning";
    private static final String SYSTEM_EXIT = "SystemExit";
    private static final String GENERATOR_EXIT = "GeneratorExit";
    private static final String KEYBOARD_INTERRUPT = "KeyboardInterrupt";
    private static final String STOP_ITERATION = "StopIteration";
    private static final String BUILTINS = "builtins";
    private static final String BUILTIN = "__builtin__";
    protected static final Object NO_RETURN_VALUE = new Object();
    protected static final int HIGHEST_PROTOCOL = 5;
    protected Map<Integer, Object> memo = new HashMap<Integer, Object>();
    protected UnpickleStack stack = new UnpickleStack();
    protected InputStream input;
    protected static Map<String, IObjectConstructor> objectConstructors = new HashMap<String, IObjectConstructor>();

    public static void registerConstructor(String module, String classname, IObjectConstructor constructor) {
        objectConstructors.put(module + MODULE_SUFFIX + classname, constructor);
    }

    public Object load(InputStream stream) throws PickleException, IOException {
        short key;
        Object value;
        this.input = stream;
        do {
            if ((key = PickleUtils.readByte(this.input)) != -1) continue;
            throw new IOException("premature end of file");
        } while ((value = this.dispatch(key)) == NO_RETURN_VALUE);
        return value;
    }

    public Object loads(byte[] pickleData) throws Exception {
        Object loadResult = this.load(new ByteArrayInputStream(pickleData));
        if (loadResult instanceof String && loadResult.toString().startsWith(PYTHON_EXCEPTION)) {
            throw new RuntimeException(loadResult.toString());
        }
        return loadResult;
    }

    public void close() {
        if (this.stack != null) {
            this.stack.clear();
        }
        if (this.memo != null) {
            this.memo.clear();
        }
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                LOGGER.error("input closed fail");
            }
        }
    }

    protected Object nextBuffer() throws PickleException {
        throw new PickleException("pickle stream refers to out-of-band data but no user-overridden nextBuffer() method is used");
    }

    protected Object dispatch(short key) throws PickleException, IOException {
        switch (key) {
            case 40: {
                this.loadMark();
                break;
            }
            case 46: {
                Object value = this.stack.pop();
                this.stack.clear();
                this.memo.clear();
                return value;
            }
            case 48: {
                this.loadPop();
                break;
            }
            case 49: {
                this.loadPopMark();
                break;
            }
            case 50: {
                this.loadDup();
                break;
            }
            case 70: {
                this.loadFloat();
                break;
            }
            case 73: {
                this.loadInt();
                break;
            }
            case 74: {
                this.loadBinint();
                break;
            }
            case 75: {
                this.loadBinint1();
                break;
            }
            case 76: {
                this.loadLong();
                break;
            }
            case 77: {
                this.loadBinint2();
                break;
            }
            case 78: {
                this.loadNone();
                break;
            }
            case 80: {
                this.loadPersid();
                break;
            }
            case 81: {
                this.loadBinpersid();
                break;
            }
            case 82: {
                this.loadReduce();
                break;
            }
            case 83: {
                this.loadString();
                break;
            }
            case 84: {
                this.loadBinstring();
                break;
            }
            case 85: {
                this.loadShortBinstring();
                break;
            }
            case 86: {
                this.loadUnicode();
                break;
            }
            case 88: {
                this.loadBinunicode();
                break;
            }
            case 97: {
                this.loadAppend();
                break;
            }
            case 98: {
                this.loadBuild();
                break;
            }
            case 99: {
                this.loadGlobal();
                break;
            }
            case 100: {
                this.loadDict();
                break;
            }
            case 125: {
                this.loadEmptyDictionary();
                break;
            }
            case 101: {
                this.loadAppends();
                break;
            }
            case 103: {
                this.loadGet();
                break;
            }
            case 104: {
                this.loadBinget();
                break;
            }
            case 105: {
                this.loadInst();
                break;
            }
            case 106: {
                this.loadLongBinget();
                break;
            }
            case 108: {
                this.loadList();
                break;
            }
            case 93: {
                this.loadEmptyList();
                break;
            }
            case 111: {
                this.loadObj();
                break;
            }
            case 112: {
                this.loadPut();
                break;
            }
            case 113: {
                this.loadBinput();
                break;
            }
            case 114: {
                this.loadLongBinput();
                break;
            }
            case 115: {
                this.loadSetitem();
                break;
            }
            case 116: {
                this.loadTuple();
                break;
            }
            case 41: {
                this.loadEmptyTuple();
                break;
            }
            case 117: {
                this.loadSetitems();
                break;
            }
            case 71: {
                this.loadBinfloat();
                break;
            }
            case 128: {
                this.loadProto();
                break;
            }
            case 129: {
                this.loadNewBbj();
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                throw new PickleException("Unimplemented opcode EXT1/EXT2/EXT4 encountered.");
            }
            case 133: {
                this.loadTuple1();
                break;
            }
            case 134: {
                this.loadTuple2();
                break;
            }
            case 135: {
                this.loadTuple3();
                break;
            }
            case 136: {
                this.loadTrue();
                break;
            }
            case 137: {
                this.loadFalse();
                break;
            }
            case 138: {
                this.loadLong1();
                break;
            }
            case 139: {
                this.loadLong4();
                break;
            }
            case 66: {
                this.loadBinBytes();
                break;
            }
            case 67: {
                this.loadShortBinBytes();
                break;
            }
            case 141: {
                this.loadBinunicode8();
                break;
            }
            case 140: {
                this.loadShortBinunicode();
                break;
            }
            case 142: {
                this.loadBinBytes8();
                break;
            }
            case 143: {
                this.loadEmptySet();
                break;
            }
            case 144: {
                this.loadAddItems();
                break;
            }
            case 145: {
                this.loadFrozenset();
                break;
            }
            case 148: {
                this.loadMemoize();
                break;
            }
            case 149: {
                this.loadFrame();
                break;
            }
            case 146: {
                this.loadNewObjEx();
                break;
            }
            case 147: {
                this.loadStackGlobal();
                break;
            }
            case 150: {
                this.loadByteArray8();
                break;
            }
            case 152: {
                this.loadReadonlyBuffer();
                break;
            }
            case 151: {
                this.loadNextBuffer();
                break;
            }
            default: {
                throw new InvalidOpcodeException("invalid pickle opcode: " + key);
            }
        }
        return NO_RETURN_VALUE;
    }

    private void loadReadonlyBuffer() {
    }

    private void loadNextBuffer() throws PickleException {
        this.stack.add(this.nextBuffer());
    }

    private void loadByteArray8() throws IOException {
        long len = PickleUtils.bytes2Long(PickleUtils.readBytes(this.input, 8), 0);
        this.stack.add(PickleUtils.readBytes(this.input, len));
    }

    private void loadBuild() {
        Object args = this.stack.pop();
        Object target = this.stack.peek();
        try {
            Method setStateMethod = target.getClass().getMethod(SET_STATE, args.getClass());
            setStateMethod.invoke(target, args);
        }
        catch (Exception e) {
            throw new PickleException("failed to setState()", e);
        }
    }

    private void loadProto() throws IOException {
        short proto = PickleUtils.readByte(this.input);
        if (proto < 0 || proto > 5) {
            throw new PickleException("unsupported pickle protocol: " + proto);
        }
    }

    private void loadNone() {
        this.stack.add(null);
    }

    private void loadFalse() {
        this.stack.add(false);
    }

    private void loadTrue() {
        this.stack.add(true);
    }

    private void loadInt() throws IOException {
        Comparable<Boolean> val;
        String data = PickleUtils.readLine(this.input, true);
        if (data.equals("I00\n".substring(1))) {
            val = false;
        } else if (data.equals("I01\n".substring(1))) {
            val = true;
        } else {
            String number = data.substring(0, data.length() - 1);
            try {
                val = Integer.parseInt(number, 10);
            }
            catch (NumberFormatException x) {
                val = Long.parseLong(number, 10);
            }
        }
        this.stack.add(val);
    }

    private void loadBinint() throws IOException {
        int integer = PickleUtils.bytes2Integer(PickleUtils.readBytes(this.input, 4));
        this.stack.add(integer);
    }

    private void loadBinint1() throws IOException {
        this.stack.add(PickleUtils.readByte(this.input));
    }

    private void loadBinint2() throws IOException {
        int integer = PickleUtils.bytes2Integer(PickleUtils.readBytes(this.input, 2));
        this.stack.add(integer);
    }

    private void loadLong() throws IOException {
        String val = PickleUtils.readLine(this.input);
        if (val.endsWith(LONG_END_WITH)) {
            val = val.substring(0, val.length() - 1);
        }
        BigInteger bi = new BigInteger(val);
        this.stack.add(PickleUtils.optimizeBigint(bi));
    }

    private void loadLong1() throws IOException {
        short n = PickleUtils.readByte(this.input);
        byte[] data = PickleUtils.readBytes(this.input, n);
        this.stack.add(PickleUtils.decodeLong(data));
    }

    private void loadLong4() throws IOException {
        int n = PickleUtils.bytes2Integer(PickleUtils.readBytes(this.input, 4));
        byte[] data = PickleUtils.readBytes(this.input, n);
        this.stack.add(PickleUtils.decodeLong(data));
    }

    private void loadFloat() throws IOException {
        String val = PickleUtils.readLine(this.input, true);
        this.stack.add(Double.parseDouble(val));
    }

    private void loadBinfloat() throws IOException {
        double val = PickleUtils.bytes2Double(PickleUtils.readBytes(this.input, 8), 0);
        this.stack.add(val);
    }

    private void loadString() throws IOException {
        String rep = PickleUtils.readLine(this.input);
        boolean quotesOk = false;
        for (String q : new String[]{"\"", "'"}) {
            if (!rep.startsWith(q)) continue;
            if (!rep.endsWith(q)) {
                throw new PickleException("insecure string pickle");
            }
            rep = rep.substring(1, rep.length() - 1);
            quotesOk = true;
            break;
        }
        if (!quotesOk) {
            throw new PickleException("insecure string pickle");
        }
        this.stack.add(PickleUtils.decodeEscaped(rep));
    }

    private void loadBinstring() throws IOException {
        int len = PickleUtils.bytes2Integer(PickleUtils.readBytes(this.input, 4));
        byte[] data = PickleUtils.readBytes(this.input, len);
        this.stack.add(PickleUtils.rawStringFromBytes(data));
    }

    private void loadBinBytes() throws IOException {
        int len = PickleUtils.bytes2Integer(PickleUtils.readBytes(this.input, 4));
        this.stack.add(PickleUtils.readBytes(this.input, len));
    }

    private void loadBinBytes8() throws IOException {
        long len = PickleUtils.bytes2Long(PickleUtils.readBytes(this.input, 8), 0);
        this.stack.add(PickleUtils.readBytes(this.input, len));
    }

    private void loadUnicode() throws IOException {
        String str = PickleUtils.decodeUnicodeEscaped(PickleUtils.readLine(this.input));
        this.stack.add(str);
    }

    private void loadBinunicode() throws IOException {
        int len = PickleUtils.bytes2Integer(PickleUtils.readBytes(this.input, 4));
        byte[] data = PickleUtils.readBytes(this.input, len);
        this.stack.add(new String(data, StandardCharsets.UTF_8));
    }

    private void loadBinunicode8() throws IOException {
        long len = PickleUtils.bytes2Long(PickleUtils.readBytes(this.input, 8), 0);
        byte[] data = PickleUtils.readBytes(this.input, len);
        this.stack.add(new String(data, StandardCharsets.UTF_8));
    }

    private void loadShortBinunicode() throws IOException {
        short len = PickleUtils.readByte(this.input);
        byte[] data = PickleUtils.readBytes(this.input, len);
        this.stack.add(new String(data, StandardCharsets.UTF_8));
    }

    private void loadShortBinstring() throws IOException {
        short len = PickleUtils.readByte(this.input);
        byte[] data = PickleUtils.readBytes(this.input, len);
        this.stack.add(PickleUtils.rawStringFromBytes(data));
    }

    private void loadShortBinBytes() throws IOException {
        short len = PickleUtils.readByte(this.input);
        this.stack.add(PickleUtils.readBytes(this.input, len));
    }

    private void loadTuple() {
        List<Object> top = this.stack.popAllSinceMarker();
        this.stack.add(top.toArray());
    }

    private void loadEmptyTuple() {
        this.stack.add(new Object[0]);
    }

    private void loadTuple1() {
        this.stack.add(new Object[]{this.stack.pop()});
    }

    private void loadTuple2() {
        Object o2 = this.stack.pop();
        Object o1 = this.stack.pop();
        this.stack.add(new Object[]{o1, o2});
    }

    private void loadTuple3() {
        Object o3 = this.stack.pop();
        Object o2 = this.stack.pop();
        Object o1 = this.stack.pop();
        this.stack.add(new Object[]{o1, o2, o3});
    }

    private void loadEmptyList() {
        this.stack.add(new ArrayList(0));
    }

    private void loadEmptyDictionary() {
        this.stack.add(new HashMap(0));
    }

    private void loadEmptySet() {
        this.stack.add(new HashSet());
    }

    private void loadList() {
        List<Object> top = this.stack.popAllSinceMarker();
        this.stack.add(top);
    }

    private void loadDict() {
        List<Object> top = this.stack.popAllSinceMarker();
        HashMap<Object, Object> map = new HashMap<Object, Object>(top.size());
        for (int i = 0; i < top.size(); i += 2) {
            Object key = top.get(i);
            Object value = top.get(i + 1);
            map.put(key, value);
        }
        this.stack.add(map);
    }

    private void loadFrozenset() {
        List<Object> top = this.stack.popAllSinceMarker();
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(top);
        this.stack.add(set);
    }

    private void loadAddItems() {
        List<Object> top = this.stack.popAllSinceMarker();
        HashSet set = (HashSet)this.stack.pop();
        set.addAll(top);
        this.stack.add(set);
    }

    private void loadGlobal() throws IOException {
        String module = PickleUtils.readLine(this.input);
        String name = PickleUtils.readLine(this.input);
        this.loadGlobalSub(module, name);
    }

    private void loadStackGlobal() {
        String name = (String)this.stack.pop();
        String module = (String)this.stack.pop();
        this.loadGlobalSub(module, name);
    }

    private void loadGlobalSub(String module, String name) {
        IObjectConstructor constructor = objectConstructors.get(module + MODULE_SUFFIX + name);
        if (constructor == null) {
            constructor = module.equals(EXCEPTIONS) ? new ExceptionConstructor(PythonException.class, module, name) : (module.equals(BUILTIN) || module.equals(BUILTINS) ? (name.endsWith(ERROR) || name.endsWith(WARNING) || name.endsWith(EXCEPTION) || name.equals(KEYBOARD_INTERRUPT) || name.equals(STOP_ITERATION) || name.equals(GENERATOR_EXIT) || name.equals(SYSTEM_EXIT) ? new ExceptionConstructor(PythonException.class, module, name) : new DictionaryConstructor(module, name)) : new DictionaryConstructor(module, name));
        }
        this.stack.add(constructor);
    }

    private void loadPop() {
        this.stack.pop();
    }

    private void loadPopMark() {
        Object o;
        while ((o = this.stack.pop()) != this.stack.marker) {
        }
        this.stack.trim();
    }

    private void loadDup() {
        this.stack.add(this.stack.peek());
    }

    private void loadGet() throws IOException {
        int i = Integer.parseInt(PickleUtils.readLine(this.input), 10);
        if (!this.memo.containsKey(i)) {
            throw new PickleException("invalid memo key");
        }
        this.stack.add(this.memo.get(i));
    }

    private void loadBinget() throws IOException {
        short i = PickleUtils.readByte(this.input);
        if (!this.memo.containsKey(i)) {
            throw new PickleException("invalid memo key");
        }
        this.stack.add(this.memo.get(i));
    }

    private void loadLongBinget() throws IOException {
        int i = PickleUtils.bytes2Integer(PickleUtils.readBytes(this.input, 4));
        if (!this.memo.containsKey(i)) {
            throw new PickleException("invalid memo key");
        }
        this.stack.add(this.memo.get(i));
    }

    private void loadPut() throws IOException {
        int i = Integer.parseInt(PickleUtils.readLine(this.input), 10);
        this.memo.put(i, this.stack.peek());
    }

    private void loadBinput() throws IOException {
        short i = PickleUtils.readByte(this.input);
        this.memo.put(Integer.valueOf(i), this.stack.peek());
    }

    private void loadLongBinput() throws IOException {
        int i = PickleUtils.bytes2Integer(PickleUtils.readBytes(this.input, 4));
        this.memo.put(i, this.stack.peek());
    }

    private void loadMemoize() {
        this.memo.put(this.memo.size(), this.stack.peek());
    }

    private void loadAppend() {
        Object value = this.stack.pop();
        ArrayList list = (ArrayList)this.stack.peek();
        list.add(value);
    }

    private void loadAppends() {
        List<Object> top = this.stack.popAllSinceMarker();
        ArrayList list = (ArrayList)this.stack.peek();
        list.addAll(top);
        list.trimToSize();
    }

    private void loadSetitem() {
        Object value = this.stack.pop();
        Object key = this.stack.pop();
        Map dict = (Map)this.stack.peek();
        dict.put(key, value);
    }

    private void loadSetitems() {
        HashMap<Object, Object> newItems = new HashMap<Object, Object>();
        Object value = this.stack.pop();
        while (value != this.stack.marker) {
            Object key = this.stack.pop();
            newItems.put(key, value);
            value = this.stack.pop();
        }
        Map dict = (Map)this.stack.peek();
        dict.putAll(newItems);
    }

    private void loadMark() {
        this.stack.addMark();
    }

    private void loadReduce() {
        Object[] args = (Object[])this.stack.pop();
        IObjectConstructor constructor = (IObjectConstructor)this.stack.pop();
        this.stack.add(constructor.construct(args));
    }

    private void loadNewBbj() {
        this.loadReduce();
    }

    private void loadNewObjEx() {
        HashMap kwargs = (HashMap)this.stack.pop();
        Object[] args = (Object[])this.stack.pop();
        IObjectConstructor constructor = (IObjectConstructor)this.stack.pop();
        if (kwargs.size() != 0) {
            throw new PickleException("loadNewObjEx with keyword arguments not supported");
        }
        this.stack.add(constructor.construct(args));
    }

    private void loadFrame() throws IOException {
        PickleUtils.readBytes(this.input, 8);
    }

    private void loadPersid() throws IOException {
        String pid = PickleUtils.readLine(this.input);
        this.stack.add(this.persistentLoad(pid));
    }

    private void loadBinpersid() {
        String pid = this.stack.pop().toString();
        this.stack.add(this.persistentLoad(pid));
    }

    private void loadObj() {
        List<Object> args = this.stack.popAllSinceMarker();
        IObjectConstructor constructor = (IObjectConstructor)args.get(0);
        args = args.subList(1, args.size());
        Object object = constructor.construct(args.toArray());
        this.stack.add(object);
    }

    private void loadInst() throws IOException {
        String module = PickleUtils.readLine(this.input);
        String classname = PickleUtils.readLine(this.input);
        List<Object> args = this.stack.popAllSinceMarker();
        IObjectConstructor constructor = objectConstructors.get(module + MODULE_SUFFIX + classname);
        if (constructor == null) {
            constructor = new DictionaryConstructor(module, classname);
            args.clear();
        }
        Object object = constructor.construct(args.toArray());
        this.stack.add(object);
    }

    protected Object persistentLoad(String pid) {
        throw new PickleException("A load persistent id instruction was encountered, but no persistentLoad function was specified. pid: " + pid);
    }

    static {
        objectConstructors.put("__builtin__.complex", new ComplexNumberConstructor());
        objectConstructors.put("builtins.complex", new ComplexNumberConstructor());
        objectConstructors.put("array.array", new ArrayConstructor());
        objectConstructors.put("array._array_reconstructor", new ArrayConstructor());
        objectConstructors.put("__builtin__.bytearray", new ByteArrayConstructor());
        objectConstructors.put("builtins.bytearray", new ByteArrayConstructor());
        objectConstructors.put("__builtin__.bytes", new ByteArrayConstructor());
        objectConstructors.put("_codecs.encode", new ByteArrayConstructor());
    }
}

