/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.log;

import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Consumer;

public class ProcessErrorOutputLogger
implements Runnable {
    private static final String LINE_SIGNAL = "\n";
    private final StringBuilder buffer = new StringBuilder();
    private final InputStream inputStream;
    private final Consumer<String> consumer;

    public ProcessErrorOutputLogger(InputStream inputStream, Consumer<String> consumer) {
        this.inputStream = inputStream;
        this.consumer = consumer;
    }

    @Override
    public void run() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
            while ((line = reader.readLine()) != null) {
                this.buffer.append(line).append(LINE_SIGNAL);
                this.consumer.accept(line);
            }
        }
        catch (Exception e) {
            this.consumer.accept(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public String get() {
        return this.buffer.toString();
    }
}

