/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.log;

import com.antgroup.geaflow.common.utils.ThreadUtil;
import com.antgroup.geaflow.infer.log.ProcessErrorOutputLogger;
import com.antgroup.geaflow.infer.log.ProcessOutputConsumer;
import com.antgroup.geaflow.infer.log.ProcessStdOutputLogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ProcessLoggerManager
implements AutoCloseable {
    private static final String PROCESS_LOG_PREFIX = "infer-process-log";
    private static final int PROCESS_THREAD_NUM = 2;
    private final Process process;
    private final ProcessOutputConsumer processOutputConsumer;
    private ProcessErrorOutputLogger errorOutputLogger;
    private final ExecutorService executor;

    public ProcessLoggerManager(Process process, ProcessOutputConsumer processOutputConsumer) {
        this.process = process;
        this.processOutputConsumer = processOutputConsumer;
        this.executor = Executors.newFixedThreadPool(2, ThreadUtil.namedThreadFactory((boolean)true, (String)PROCESS_LOG_PREFIX));
    }

    public void startLogging() {
        this.executor.execute(new ProcessStdOutputLogger(this.process.getInputStream(), this.processOutputConsumer.getStdOutConsumer()));
        this.errorOutputLogger = new ProcessErrorOutputLogger(this.process.getErrorStream(), this.processOutputConsumer.getStdErrConsumer());
        this.executor.execute(this.errorOutputLogger);
    }

    public ProcessErrorOutputLogger getErrorOutputLogger() {
        return this.errorOutputLogger;
    }

    @Override
    public void close() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }
}

