/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.util;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.file.FileConfigKeys;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InferFileUtils.class);
    public static final String INFER_DIRECTORY = "infer";
    private static final String FILE_SUFFIX = "/";
    private static final String JAR_FILE = "jar:file:";
    private static final String UDF_RESOURCE_PATH = ".";
    public static final String PY_FILE_EXTENSION = ".py";
    public static final String JAR_FILE_EXTENSION = ".jar";
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final String MODEL_FILE_EXTENSION = ".pt";
    public static final String MODEL_NAME = "model.pt";
    public static final String REQUIREMENTS_TXT = "requirements.txt";

    public static void releaseLock(FileLock fileLock) {
        try {
            fileLock.release();
            fileLock.channel().close();
        }
        catch (IOException e) {
            LOGGER.error("release file lock failed", (Throwable)e);
        }
    }

    public static FileLock addLock(File file) {
        try {
            FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.WRITE);
            return channel.lock();
        }
        catch (Exception e) {
            LOGGER.error("add lock file {} error", (Object)file.toPath(), (Object)e);
            throw new GeaflowRuntimeException("get file lock failed", (Throwable)e);
        }
    }

    public static void forceMkdir(File directory) throws IOException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                String message = String.format("File %s exists and is not a directory. Unable to create directory.", directory);
                throw new IOException(message);
            }
        } else if (!directory.mkdirs() && !directory.isDirectory()) {
            String message = "Unable to create directory " + directory;
            throw new IOException(message);
        }
    }

    public static String copyPythonFile(String parentDir, File resourceFile) {
        File targetFile = new File((parentDir = parentDir.endsWith(FILE_SUFFIX) ? parentDir : parentDir + FILE_SUFFIX) + resourceFile.getName());
        if (targetFile.exists()) {
            targetFile.delete();
            LOGGER.info("{} file is existed, delete", (Object)targetFile.getAbsolutePath());
        }
        try {
            FileUtils.copyFile((File)resourceFile, (File)targetFile);
        }
        catch (Exception e) {
            throw new GeaflowRuntimeException(String.format("prepare python file [%s] failed, %s", resourceFile.getName(), e.getMessage()));
        }
        LOGGER.info("prepare python file [{}] finish", (Object)resourceFile.getName());
        Preconditions.checkState((boolean)targetFile.exists());
        return targetFile.getAbsolutePath();
    }

    public static String copyInferFileByURL(String parentPath, String resourceFilePath) {
        File sourceFile = new File(resourceFilePath.trim());
        File file = new File((parentPath = parentPath.endsWith(FILE_SUFFIX) ? parentPath : parentPath + FILE_SUFFIX) + sourceFile.getName());
        if (file.exists()) {
            file.delete();
            LOGGER.info("{} file is existed, delete", (Object)file.getAbsolutePath());
        }
        try {
            URL url = InferFileUtils.class.getClassLoader().getResource(resourceFilePath);
            Preconditions.checkNotNull((Object)url, (Object)String.format("Cannot find resource file [%s] in classpath", resourceFilePath));
            File tmpFile = new File(file.getParent() + File.separator + "tmp_" + file.getName());
            FileUtils.copyURLToFile((URL)url, (File)tmpFile);
            tmpFile.renameTo(file);
        }
        catch (Exception e) {
            throw new GeaflowRuntimeException(String.format("prepare python file [%s] failed by url, %s", resourceFilePath, e.getMessage()));
        }
        LOGGER.info("prepare python file [{}] finish by url", (Object)resourceFilePath);
        return file.getAbsolutePath();
    }

    public static String copyPythonFile(String parentDir, File resourceFile, String reName) {
        File targetFile = new File((parentDir = parentDir.endsWith(FILE_SUFFIX) ? parentDir : parentDir + FILE_SUFFIX) + reName);
        if (targetFile.exists()) {
            targetFile.delete();
            LOGGER.info("{} file is existed, delete", (Object)targetFile.getAbsolutePath());
        }
        try {
            FileUtils.copyFile((File)resourceFile, (File)targetFile);
        }
        catch (Exception e) {
            throw new GeaflowRuntimeException(String.format("prepare python file [%s] and rename [%s] failed, %s", resourceFile.getName(), reName, e.getMessage()));
        }
        LOGGER.info("prepare python file [{}] and rename [{}] finish", (Object)resourceFile.getName(), (Object)reName);
        Preconditions.checkState((boolean)targetFile.exists());
        return targetFile.getAbsolutePath();
    }

    public static List<File> getPythonFilesByCondition(FileFilter fileFilter) {
        String jobPackagePath = Resources.getResource((String)UDF_RESOURCE_PATH).getPath();
        File folder = new File(jobPackagePath);
        for (File file : folder.listFiles()) {
            LOGGER.info("folder {} sub file {}", (Object)folder.getAbsolutePath(), (Object)file.getName());
        }
        File[] subFiles = folder.listFiles(fileFilter);
        if (subFiles == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(subFiles);
    }

    public static File getUserJobJarFile() {
        String jobPackagePath = Resources.getResource((String)UDF_RESOURCE_PATH).getPath();
        File folder = new File(jobPackagePath);
        for (File file : folder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(JAR_FILE_EXTENSION)) continue;
            LOGGER.info("folder {} user job jar is {}", (Object)folder.getAbsolutePath(), (Object)file.getName());
            return file;
        }
        return null;
    }

    public static String getInferDirectory(Configuration configuration) {
        String workPath = configuration.getString(ExecutionConfigKeys.JOB_WORK_PATH);
        String userName = configuration.getString(FileConfigKeys.USER_NAME);
        String inferPath = workPath + File.separator + userName + File.separator + INFER_DIRECTORY;
        String jobUniqueId = configuration.getString(ExecutionConfigKeys.JOB_UNIQUE_ID);
        File inferFile = new File(inferPath + File.separator + jobUniqueId);
        if (!inferFile.exists()) {
            inferFile.mkdirs();
        }
        return inferFile.getAbsolutePath();
    }

    public static String createTargetDir(String dirName, Configuration configuration) {
        String inferDirectory = InferFileUtils.getInferDirectory(configuration);
        File userFilesDirFile = new File(inferDirectory, dirName);
        if (!userFilesDirFile.exists()) {
            userFilesDirFile.mkdirs();
        }
        String absolutePath = userFilesDirFile.getAbsolutePath();
        LOGGER.info("create infer directory is {}", (Object)absolutePath);
        return absolutePath;
    }

    public static List<Path> getPathsFromResourceJAR(String folder) throws URISyntaxException, IOException {
        List<Path> result;
        String jarPath = InferFileUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        LOGGER.info("jar path {}", (Object)jarPath);
        URI uri = URI.create(JAR_FILE + jarPath);
        try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
            result = Files.walk(fs.getPath(folder, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        }
        return result;
    }

    public static void prepareInferFilesFromJars(String targetDirectory) {
        File userJobJarFile = InferFileUtils.getUserJobJarFile();
        Preconditions.checkNotNull((Object)userJobJarFile);
        int modelFileNum = 0;
        int requirementsFileNum = 0;
        try {
            JarFile jarFile = new JarFile(userJobJarFile);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory()) continue;
                if (entryName.endsWith(PY_FILE_EXTENSION)) {
                    String inferPythonFile = InferFileUtils.extractFile(targetDirectory, entryName, entry, jarFile);
                    LOGGER.info("cp infer python file {} to {} from jar file {}", new Object[]{entryName, inferPythonFile, userJobJarFile.getName()});
                    continue;
                }
                if (entryName.endsWith(MODEL_FILE_EXTENSION)) {
                    Preconditions.checkState((++modelFileNum == 1 ? 1 : 0) != 0, (Object)"upload infer model file num more than 1");
                    String modelFilePath = InferFileUtils.extractFile(targetDirectory, MODEL_NAME, entry, jarFile);
                    LOGGER.info("cp infer model file {} to {} from jar file {}", new Object[]{entryName, modelFilePath, userJobJarFile.getName()});
                    continue;
                }
                if (!REQUIREMENTS_TXT.equals(entryName)) continue;
                Preconditions.checkState((++requirementsFileNum == 1 ? 1 : 0) != 0, (Object)"upload env requirements file num more than 1");
                String requirementsFilePath = InferFileUtils.extractFile(targetDirectory, entryName, entry, jarFile);
                LOGGER.info("cp end requirements file {} to {} from jar file {}", new Object[]{entryName, requirementsFilePath, userJobJarFile.getName()});
            }
            jarFile.close();
        }
        catch (IOException e) {
            LOGGER.error("open jar file {} failed", (Object)userJobJarFile.getName());
        }
    }

    private static String extractFile(String targetDirectory, String fileName, JarEntry entry, JarFile jarFile) throws IOException {
        String targetFilePath = targetDirectory + File.separator + fileName;
        try (InputStream inputStream = jarFile.getInputStream(entry);
             FileOutputStream outputStream = new FileOutputStream(targetFilePath);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        return targetFilePath;
    }
}

