/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.infer.util;

import com.antgroup.geaflow.common.config.keys.FrameworkConfigKeys;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.infer.log.ProcessErrorOutputLogger;
import com.antgroup.geaflow.infer.log.ProcessStdOutputLogger;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShellExecUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellExecUtils.class);
    private static final String SHELL_KEY = "sh";
    private static final String SHELL_PARAM = "-c";
    private static final Consumer<String> DUMMY_CONSUMER = s -> {};
    private static final ExecutorService LOGGER_POOL = new ThreadPoolExecutor(2, 20, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadFactoryBuilder().setNameFormat("infer-task-log-%d").setDaemon(true).build());

    private ShellExecUtils() {
    }

    public static boolean run(String cmd, Consumer<String> stdOutputConsumer, Consumer<String> errOutputConsumer, Duration timeout, boolean allowFailure, String workingDir) {
        ProcessBuilder builder = new ProcessBuilder(SHELL_KEY, SHELL_PARAM, cmd);
        if (workingDir != null) {
            builder.directory(new File(workingDir));
        }
        Process process = null;
        int exitCode = 0;
        try {
            boolean success;
            process = builder.start();
            if (stdOutputConsumer == null) {
                stdOutputConsumer = DUMMY_CONSUMER;
            }
            if (errOutputConsumer == null) {
                errOutputConsumer = DUMMY_CONSUMER;
            }
            ProcessErrorOutputLogger processErrorOutputLogger = new ProcessErrorOutputLogger(process.getErrorStream(), errOutputConsumer);
            LOGGER_POOL.execute(new ProcessStdOutputLogger(process.getInputStream(), stdOutputConsumer));
            LOGGER_POOL.execute(processErrorOutputLogger);
            boolean finished = process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
            exitCode = process.exitValue();
            boolean bl = success = finished && exitCode == 0;
            if (!success && !allowFailure) {
                if (!finished) {
                    throw new GeaflowRuntimeException(String.format("Command %s didn't finish in time, please try increase the timeout %s", cmd, FrameworkConfigKeys.INFER_ENV_INIT_TIMEOUT_SEC));
                }
                LOGGER.error("Command {} exec failed, error message {}", (Object)cmd, (Object)processErrorOutputLogger.get());
            }
            boolean bl2 = success;
            return bl2;
        }
        catch (Exception e) {
            LOGGER.error("error running {}, exit code is {}", new Object[]{cmd, exitCode, e});
            throw new GeaflowRuntimeException("running shell exception", (Throwable)e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    public static boolean run(String cmd, Duration timeout, Consumer<String> stdOutputConsumer, Consumer<String> errOutputConsumer) {
        return ShellExecUtils.run(cmd, stdOutputConsumer, errOutputConsumer, timeout, false, null);
    }

    public static boolean run(String cmd, Duration timeout, Consumer<String> stdOutputConsumer, Consumer<String> errOutputConsumer, String workDir) {
        return ShellExecUtils.run(cmd, stdOutputConsumer, errOutputConsumer, timeout, false, workDir);
    }
}

