/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.metaserver;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.rpc.HostAndPort;
import com.antgroup.geaflow.common.serialize.SerializerFactory;
import com.antgroup.geaflow.common.utils.PortUtil;
import com.antgroup.geaflow.common.utils.ProcessUtil;
import com.antgroup.geaflow.metaserver.MetaServerContext;
import com.antgroup.geaflow.metaserver.MetaServerServiceProxy;
import com.antgroup.geaflow.metaserver.api.NamespaceServiceHandler;
import com.antgroup.geaflow.metaserver.api.ServiceHandlerFactory;
import com.antgroup.geaflow.metaserver.model.protocal.MetaRequest;
import com.antgroup.geaflow.metaserver.model.protocal.MetaResponse;
import com.antgroup.geaflow.metaserver.model.protocal.request.RequestPBConverter;
import com.antgroup.geaflow.metaserver.model.protocal.response.ResponsePBConverter;
import com.antgroup.geaflow.metaserver.service.MetaServerService;
import com.antgroup.geaflow.metaserver.service.NamespaceType;
import com.antgroup.geaflow.rpc.proto.MetaServer;
import com.antgroup.geaflow.service.discovery.ServiceBuilder;
import com.antgroup.geaflow.service.discovery.ServiceBuilderFactory;
import com.antgroup.geaflow.service.discovery.ServiceProvider;
import com.baidu.brpc.server.RpcServer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaServer
implements MetaServerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaServer.class);
    private static final int MIN_PORT = 50000;
    private static final int MAX_PORT = 60000;
    private RpcServer rpcServer;
    private Map<NamespaceType, NamespaceServiceHandler> namespaceServiceHandlerMap;
    private ServiceProvider serviceProvider;

    public void init(MetaServerContext context) {
        Configuration configuration = context.getConfiguration();
        ServiceBuilder serviceBuilder = ServiceBuilderFactory.build((String)configuration.getString(ExecutionConfigKeys.SERVICE_DISCOVERY_TYPE));
        this.serviceProvider = serviceBuilder.buildProvider(configuration);
        this.namespaceServiceHandlerMap = ServiceHandlerFactory.load(context);
        this.startServer(configuration);
    }

    private void startServer(Configuration configuration) {
        int port = PortUtil.getPort((int)50000, (int)60000);
        this.rpcServer = new RpcServer(port);
        this.rpcServer.registerService((Object)new MetaServerServiceProxy(this));
        this.rpcServer.start();
        HostAndPort info = new HostAndPort(ProcessUtil.getHostIp(), port);
        String appName = configuration.getString(ExecutionConfigKeys.JOB_APP_NAME);
        this.serviceProvider.update("app_name", appName.getBytes());
        if (this.serviceProvider.exists("meta_server")) {
            this.serviceProvider.delete("meta_server");
        }
        this.serviceProvider.createAndWatch("meta_server", SerializerFactory.getKryoSerializer().serialize((Object)info));
        LOGGER.info("{} meta server start at {}", (Object)appName, (Object)info);
    }

    public MetaServer.ServiceResultPb process(MetaServer.ServiceRequestPb serviceRequest) {
        MetaRequest request = RequestPBConverter.convert((MetaServer.ServiceRequestPb)serviceRequest);
        NamespaceServiceHandler handler = this.namespaceServiceHandlerMap.get(request.namespaceType());
        MetaResponse response = handler.process(request);
        return ResponsePBConverter.convert((MetaResponse)response);
    }

    public void close() {
        this.rpcServer.shutdown();
        this.serviceProvider.close();
    }
}

