/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.metrics.common;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import java.io.Serializable;
import java.util.Random;

public class MetricConfig
implements Serializable {
    private static final int WAIT_SECONDS = 5;
    private static final int RANDOM_SECONDS = 5;
    private static final int PERIOD_SECONDS = 5;
    private static final String REPORTER_SCHEDULE_PERIOD = "geaflow.metric.%s.schedule.period.sec";
    private final int schedulePeriod;
    private final Configuration config;
    private final Random random;

    public MetricConfig(Configuration configuration) {
        this.config = configuration;
        this.random = new Random();
        this.schedulePeriod = configuration.getInteger(ExecutionConfigKeys.SCHEDULE_PERIOD);
    }

    public String getReporterList() {
        boolean isLocal = this.config.getBoolean(ExecutionConfigKeys.RUN_LOCAL_MODE);
        if (isLocal) {
            return this.config.getString(ExecutionConfigKeys.REPORTER_LIST, "");
        }
        return this.config.getString(ExecutionConfigKeys.REPORTER_LIST);
    }

    public int getSchedulePeriodSec(String reporterName) {
        String periodKey = String.format(REPORTER_SCHEDULE_PERIOD, reporterName);
        return this.config.getInteger(periodKey, this.schedulePeriod);
    }

    public int getRandomDelaySec() {
        int randomDelay = this.random.nextInt(5) + 5;
        return this.config.getInteger(ExecutionConfigKeys.METRIC_META_REPORT_DELAY, randomDelay);
    }

    public int getRandomPeriodSec() {
        int randomPeriod = this.random.nextInt(5) + 1;
        return this.config.getInteger(ExecutionConfigKeys.METRIC_META_REPORT_PERIOD, randomPeriod);
    }

    public int getReportMaxRetries() {
        return this.config.getInteger(ExecutionConfigKeys.METRIC_META_REPORT_RETRIES);
    }
}

