/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.metrics.common;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.utils.ThreadUtil;
import com.antgroup.geaflow.metrics.common.MetricConfig;
import com.antgroup.geaflow.metrics.common.api.MetricGroup;
import com.antgroup.geaflow.metrics.common.api.MetricGroupImpl;
import com.antgroup.geaflow.metrics.common.reporter.MetricReporter;
import com.antgroup.geaflow.metrics.common.reporter.MetricReporterFactory;
import com.antgroup.geaflow.metrics.common.reporter.ScheduledReporter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricGroupRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricGroupRegistry.class);
    private static final String REPORTER_SEPARATOR = ",";
    private static MetricGroupRegistry INSTANCE;
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private final List<MetricReporter> reporterList = new ArrayList<MetricReporter>();
    private final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1, ThreadUtil.namedThreadFactory((boolean)true, (String)"metricService"));
    private final Map<String, MetricGroup> metricGroupMap = new ConcurrentHashMap<String, MetricGroup>();

    private MetricGroupRegistry() {
    }

    public static synchronized MetricGroupRegistry getInstance(Configuration config) {
        if (INSTANCE == null) {
            INSTANCE = new MetricGroupRegistry();
            INSTANCE.open(config);
        }
        return INSTANCE;
    }

    public static MetricGroupRegistry getInstance() {
        return INSTANCE;
    }

    public MetricGroup getMetricGroup() {
        return this.metricGroupMap.computeIfAbsent("default", name -> new MetricGroupImpl(this.metricRegistry));
    }

    public MetricGroup getMetricGroup(String groupName) {
        return this.metricGroupMap.computeIfAbsent(groupName, name -> new MetricGroupImpl((String)name, this.metricRegistry));
    }

    @VisibleForTesting
    public List<MetricReporter> getReporterList() {
        return this.reporterList;
    }

    private void open(Configuration config) {
        MetricConfig metricConfig = new MetricConfig(config);
        String reporterList = metricConfig.getReporterList();
        if (StringUtils.isEmpty((CharSequence)reporterList)) {
            LOGGER.warn("report list is empty");
            return;
        }
        String[] reporters = reporterList.split(REPORTER_SEPARATOR);
        try {
            for (String reporter : reporters) {
                MetricReporter metricReporter = MetricReporterFactory.getMetricReporter(reporter.toLowerCase());
                metricReporter.open(config, this.metricRegistry);
                if (metricReporter instanceof ScheduledReporter) {
                    int period = metricConfig.getSchedulePeriodSec(reporter);
                    this.executor.scheduleWithFixedDelay(new ReporterTask((ScheduledReporter)((Object)metricReporter)), period, period, TimeUnit.SECONDS);
                    LOGGER.info("schedule {} with duration {}s", (Object)reporter, (Object)period);
                }
                this.reporterList.add(metricReporter);
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to initialized metricReporters", (Throwable)e);
            throw new GeaflowRuntimeException((Throwable)e);
        }
    }

    public void close() {
        LOGGER.info("close metric service");
        for (MetricReporter metricReporter : this.reporterList) {
            metricReporter.close();
        }
    }

    private static final class ReporterTask
    extends TimerTask {
        private final ScheduledReporter reporter;

        private ReporterTask(ScheduledReporter reporter) {
            this.reporter = reporter;
        }

        @Override
        public void run() {
            try {
                this.reporter.report();
            }
            catch (Throwable t) {
                LOGGER.warn("Error while reporting metrics", t);
            }
        }
    }
}

