/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.metrics.common;

import com.codahale.metrics.MetricRegistry;

public class MetricNameFormatter {
    public static String totalHeapMetricName() {
        return "totalUsedHeapMb(N)";
    }

    public static String totalMemoryMetricName() {
        return "totalMemoryMb(N)";
    }

    public static String heapUsageRatioMetricName() {
        return "heapUsageRatio(N)";
    }

    public static String gcTimeMetricName() {
        return "gcTime(ms)";
    }

    public static String fgcCountMetricName() {
        return "fgcCount(N)";
    }

    public static String fgcTimeMetricName() {
        return "fgcTime(ms)";
    }

    public static String inputTpsMetricName(Class<?> opClass, int opId) {
        String metricName = String.format("%s[%d]%s", opClass.getSimpleName(), opId, "(N)");
        return MetricRegistry.name((String)"inputTps", (String[])new String[]{metricName});
    }

    public static String outputTpsMetricName(Class<?> opClass, int opId) {
        String metricName = String.format("%s[%d]%s", opClass.getSimpleName(), opId, "(N)");
        return MetricRegistry.name((String)"outputTps", (String[])new String[]{metricName});
    }

    public static String rtMetricName(Class<?> opClass, int opId) {
        String metricName = String.format("%s[%d]%s", opClass.getSimpleName(), opId, "(us)");
        return MetricRegistry.name((String)"processRt", (String[])new String[]{metricName});
    }

    public static String vertexTpsMetricName(Class<?> opClass, int opId) {
        String metricName = String.format("%s[%d]%s", opClass.getSimpleName(), opId, "(N)");
        return MetricRegistry.name((String)"vertexTps", (String[])new String[]{metricName});
    }

    public static String edgeTpsMetricName(Class<?> opClass, int opId) {
        String metricName = String.format("%s[%d]%s", opClass.getSimpleName(), opId, "(N)");
        return MetricRegistry.name((String)"edgeTps", (String[])new String[]{metricName});
    }

    public static String iterationFinishMetricName(Class<?> opClass, int opId, long iterationId) {
        String metricName = String.format("%s[%d:%d]%s", opClass.getSimpleName(), opId, iterationId, "(ms)");
        return MetricRegistry.name((String)"iteration", (String[])new String[]{metricName});
    }

    public static String iterationMsgMetricName(Class<?> opClass, int opId) {
        String metricName = String.format("%s[%d]%s", opClass.getSimpleName(), opId, "(N)");
        return MetricRegistry.name((String)"iterationMsgTps", (String[])new String[]{metricName});
    }

    public static String iterationAggMetricName(Class<?> opClass, int opId) {
        String metricName = String.format("%s[%d]%s", opClass.getSimpleName(), opId, "(N)");
        return MetricRegistry.name((String)"iterationAggTps", (String[])new String[]{metricName});
    }

    public static String tableInputRowName(String name) {
        String metricName = String.format("%s%s", name, "(N)");
        return MetricRegistry.name((String)"tableInputRow", (String[])new String[]{metricName});
    }

    public static String stepInputRecordName(String name) {
        String metricName = String.format("%s%s", name, "(N)");
        return MetricRegistry.name((String)"stepInputRecord", (String[])new String[]{metricName});
    }

    public static String stepOutputRecordName(String name) {
        String metricName = String.format("%s%s", name, "(N)");
        return MetricRegistry.name((String)"stepOutputRecord", (String[])new String[]{metricName});
    }

    public static String stepInputEodName(String name) {
        String metricName = String.format("%s%s", name, "(N)");
        return MetricRegistry.name((String)"stepInputEod", (String[])new String[]{metricName});
    }

    public static String tableOutputRowTpsName(String name) {
        String metricName = String.format("%s%s", name, "(row/s)");
        return MetricRegistry.name((String)"tableOutputRowTps", (String[])new String[]{metricName});
    }

    public static String tableInputRowTpsName(String tableName) {
        String metricName = String.format("%s%s", tableName, "(row/s)");
        return MetricRegistry.name((String)"tableInputRowTps", (String[])new String[]{metricName});
    }

    public static String tableInputBlockTpsName(String name) {
        String metricName = String.format("%s%s", name, "(block/s)");
        return MetricRegistry.name((String)"tableInputBlockTps", (String[])new String[]{metricName});
    }

    public static String stepInputRowTpsName(String name) {
        String metricName = String.format("%s%s", name, "(row/s)");
        return MetricRegistry.name((String)"stepInputRowTps", (String[])new String[]{metricName});
    }

    public static String stepOutputRowTpsName(String name) {
        String metricName = String.format("%s%s", name, "(row/s)");
        return MetricRegistry.name((String)"stepOutputRowTps", (String[])new String[]{metricName});
    }

    public static String tableWriteTimeRtName(String name) {
        String metricName = String.format("%s%s", name, "(ms)");
        return MetricRegistry.name((String)"tableWriteTimeRt", (String[])new String[]{metricName});
    }

    public static String tableFlushTimeRtName(String name) {
        String metricName = String.format("%s%s", name, "(ms)");
        return MetricRegistry.name((String)"tableFlushTimeRt", (String[])new String[]{metricName});
    }

    public static String tableParserTimeRtName(String name) {
        String metricName = String.format("%s%s", name, "(us)");
        return MetricRegistry.name((String)"tableParserTimeRt", (String[])new String[]{metricName});
    }

    public static String stepProcessTimeRtName(String name) {
        String metricName = String.format("%s%s", name, "(us)");
        return MetricRegistry.name((String)"stepProcessTimeRt", (String[])new String[]{metricName});
    }

    public static String loadEdgeCountRtName(String name) {
        String metricName = String.format("%s%s", name, "(N)");
        return MetricRegistry.name((String)"loadEdgeCountRt", (String[])new String[]{metricName});
    }

    public static String loadEdgeTimeRtName(String name) {
        String metricName = String.format("%s%s", name, "(ms)");
        return MetricRegistry.name((String)"loadEdgeTimeRt", (String[])new String[]{metricName});
    }

    public static String loadVertexTimeRtName(String name) {
        String metricName = String.format("%s%s", name, "(ms)");
        return MetricRegistry.name((String)"loadVertexTimeRt", (String[])new String[]{metricName});
    }
}

