/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.metrics.reporter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.utils.ProcessUtil;
import com.antgroup.geaflow.metrics.common.AggType;
import com.antgroup.geaflow.metrics.common.DownSample;
import com.antgroup.geaflow.metrics.common.HistAggType;
import com.antgroup.geaflow.metrics.common.MetricType;
import com.antgroup.geaflow.metrics.common.reporter.MetricReporter;
import com.antgroup.geaflow.metrics.reporter.MetricMetaClient;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReporter
implements MetricReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReporter.class);
    public static final String TAG_JOB_NAME = "jobName";
    public static final String TAG_WORKER = "worker";
    public static final String TAG_ENGINE = "engine";
    public static final String KEY_TAGS = "tags";
    public static final String KEY_METRIC = "metric";
    public static final String KEY_AGGREGATOR = "aggregator";
    public static final String KEY_DOWN_SAMPLE = "downsample";
    public static final String KEY_GEAFLOW = "Geaflow";
    protected MetricRegistry metricRegistry;
    private MetricMetaClient metricMetaClient;
    protected Map<String, String> globalTags;
    protected String jobName;

    public void open(Configuration config, MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.jobName = config.getString(ExecutionConfigKeys.JOB_APP_NAME);
        this.globalTags = new HashMap<String, String>();
        this.globalTags.put(TAG_JOB_NAME, this.jobName);
        this.globalTags.put(TAG_WORKER, ProcessUtil.getHostAndPid());
        this.globalTags.put(TAG_ENGINE, KEY_GEAFLOW);
    }

    protected void addMetricRegisterListener(Configuration config) {
        this.metricMetaClient = MetricMetaClient.getInstance(config);
        this.metricRegistry.addListener((MetricRegistryListener)new MetricRegisterListener(this.metricMetaClient));
        LOGGER.info("add metric register listener");
    }

    public void close() {
        if (this.metricMetaClient != null) {
            this.metricMetaClient.close();
            LOGGER.info("close metric meta client");
        }
    }

    private JSONObject buildQueryTags() {
        JSONObject tags = new JSONObject();
        tags.put(TAG_JOB_NAME, (Object)this.jobName);
        return tags;
    }

    protected class MetricRegisterListener
    extends MetricRegistryListener.Base {
        private final MetricMetaClient metricMetaClient;

        public MetricRegisterListener(MetricMetaClient metricMetaClient) {
            this.metricMetaClient = metricMetaClient;
        }

        public void onGaugeAdded(String metricName, Gauge<?> gauge) {
            String query = this.wrapQuery(metricName, DownSample.AVG, AggType.AVG);
            this.metricMetaClient.registerMetricMeta(metricName, MetricType.GAUGE, query);
        }

        public void onCounterAdded(String metricName, Counter counter) {
            String query = this.wrapQuery(metricName, DownSample.SUM, AggType.SUM);
            this.metricMetaClient.registerMetricMeta(metricName, MetricType.COUNTER, query);
        }

        public void onMeterAdded(String metricName, Meter meter) {
            String query = this.wrapQuery(metricName, DownSample.SUM, AggType.SUM);
            this.metricMetaClient.registerMetricMeta(metricName, MetricType.METER, query);
        }

        public void onHistogramAdded(String metricName, Histogram histogram) {
            JSONObject queryTags = AbstractReporter.this.buildQueryTags();
            HistAggType aggType = HistAggType.DEFAULT;
            JSONArray histogramQueries = new JSONArray();
            for (String aggregator : aggType.getAggTypes()) {
                JSONObject query = new JSONObject();
                query.put(AbstractReporter.KEY_TAGS, (Object)queryTags);
                query.put(AbstractReporter.KEY_METRIC, (Object)metricName);
                query.put(AbstractReporter.KEY_AGGREGATOR, (Object)aggregator);
                query.put(AbstractReporter.KEY_DOWN_SAMPLE, (Object)DownSample.AVG.getValue());
                histogramQueries.add((Object)query);
            }
            this.metricMetaClient.registerMetricMeta(metricName, MetricType.HISTOGRAM, JSON.toJSONString((Object)histogramQueries, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        }

        private String wrapQuery(String metricName, DownSample downSample, AggType aggregator) {
            JSONObject query = new JSONObject();
            query.put(AbstractReporter.KEY_METRIC, (Object)metricName);
            query.put(AbstractReporter.KEY_AGGREGATOR, (Object)aggregator.getValue());
            query.put(AbstractReporter.KEY_DOWN_SAMPLE, (Object)downSample.getValue());
            JSONObject tags = AbstractReporter.this.buildQueryTags();
            query.put(AbstractReporter.KEY_TAGS, (Object)tags);
            JSONArray meterQueries = new JSONArray();
            meterQueries.add((Object)query);
            return meterQueries.toJSONString();
        }
    }
}

