/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.metrics.reporter;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.utils.SleepUtils;
import com.antgroup.geaflow.common.utils.ThreadUtil;
import com.antgroup.geaflow.metrics.common.MetricConfig;
import com.antgroup.geaflow.metrics.common.MetricMeta;
import com.antgroup.geaflow.metrics.common.MetricType;
import com.antgroup.geaflow.stats.collector.StatsCollectorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricMetaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricMetaClient.class);
    private static MetricMetaClient reporterClient;
    private int failNum = 0;
    private final int maxRetries;
    private final String jobName;
    private final List<MetricMeta> metricList = new ArrayList<MetricMeta>();
    private final BlockingQueue<MetricMeta> metricMetaQueue = new LinkedBlockingQueue<MetricMeta>();
    private final MetricConfig metricConfig;
    private final ScheduledExecutorService scheduledService;

    private MetricMetaClient(Configuration config) {
        this.jobName = config.getString(ExecutionConfigKeys.JOB_APP_NAME);
        this.metricConfig = new MetricConfig(config);
        this.maxRetries = this.metricConfig.getReportMaxRetries();
        this.scheduledService = new ScheduledThreadPoolExecutor(1, ThreadUtil.namedThreadFactory((boolean)true, (String)"async-metric-meta"));
        this.scheduledService.scheduleAtFixedRate(new RegisterTask(), this.metricConfig.getRandomDelaySec(), this.metricConfig.getRandomPeriodSec(), TimeUnit.SECONDS);
    }

    public static synchronized MetricMetaClient getInstance(Configuration config) {
        if (reporterClient == null) {
            reporterClient = new MetricMetaClient(config);
        }
        return reporterClient;
    }

    public void registerMetricMeta(String metricName, MetricType metricType, String queries) {
        MetricMeta metricMeta = new MetricMeta();
        metricMeta.setJobName(this.jobName);
        metricMeta.setMetricName(metricName);
        metricMeta.setQueries(queries);
        metricMeta.setMetricType(metricType.name());
        this.metricMetaQueue.add(metricMeta);
    }

    public void close() {
        if (this.scheduledService != null) {
            this.scheduledService.shutdown();
        }
    }

    private class RegisterTask
    implements Runnable {
        private RegisterTask() {
        }

        @Override
        public void run() {
            try {
                if (MetricMetaClient.this.metricMetaQueue.size() > 0 || MetricMetaClient.this.metricList.size() > 0) {
                    if (MetricMetaClient.this.metricList.size() == 0) {
                        MetricMetaClient.this.metricMetaQueue.drainTo(MetricMetaClient.this.metricList);
                    }
                    SleepUtils.sleepSecond((long)MetricMetaClient.this.metricConfig.getRandomPeriodSec());
                    for (MetricMeta metricMeta : MetricMetaClient.this.metricList) {
                        StatsCollectorFactory.getInstance().getMetricMetaCollector().reportMetricMeta(metricMeta);
                        LOGGER.info("register {} with query: {}", (Object)metricMeta.getMetricName(), (Object)metricMeta.getQueries());
                    }
                    MetricMetaClient.this.metricList.clear();
                    MetricMetaClient.this.failNum = 0;
                }
            }
            catch (RuntimeException ex) {
                MetricMetaClient.this.failNum++;
                if (MetricMetaClient.this.failNum < MetricMetaClient.this.maxRetries) {
                    LOGGER.warn("register fail #{}, and retry in next round", (Object)MetricMetaClient.this.failNum, (Object)ex);
                } else {
                    LOGGER.warn("#{} retry exceeds {} times, discard {} metrics meta", new Object[]{MetricMetaClient.this.failNum, MetricMetaClient.this.maxRetries, MetricMetaClient.this.metricList.size()});
                    MetricMetaClient.this.metricList.clear();
                    MetricMetaClient.this.failNum = 0;
                }
                throw ex;
            }
        }
    }
}

