/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.metrics.slf4j;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.metrics.common.reporter.ScheduledReporter;
import com.antgroup.geaflow.metrics.reporter.AbstractReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jReporter
extends AbstractReporter
implements ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Slf4jReporter.class);
    private static final String TYPE_SLF4J = "slf4j";
    private static final String LINE_SEPARATOR = System.lineSeparator();

    public void open(Configuration jobConfig, MetricRegistry metricRegistry) {
        super.open(jobConfig, metricRegistry);
    }

    public void report() {
        StringBuilder builder = new StringBuilder();
        builder.append(LINE_SEPARATOR).append("=========================== Starting metrics report ===========================").append(LINE_SEPARATOR);
        builder.append(LINE_SEPARATOR).append("-- Counters -------------------------------------------------------------------").append(LINE_SEPARATOR);
        for (Map.Entry metric : this.metricRegistry.getCounters().entrySet()) {
            builder.append((String)metric.getKey()).append(": ").append(((Counter)metric.getValue()).getCount()).append(LINE_SEPARATOR);
        }
        builder.append(LINE_SEPARATOR).append("-- Gauges ---------------------------------------------------------------------").append(LINE_SEPARATOR);
        for (Map.Entry metric : this.metricRegistry.getGauges().entrySet()) {
            builder.append((String)metric.getKey()).append(": ").append(((Gauge)metric.getValue()).getValue()).append(LINE_SEPARATOR);
        }
        builder.append(LINE_SEPARATOR).append("-- Meters ---------------------------------------------------------------------").append(LINE_SEPARATOR);
        for (Map.Entry metric : this.metricRegistry.getMeters().entrySet()) {
            Meter meter = (Meter)metric.getValue();
            builder.append((String)metric.getKey()).append(": ").append(meter.getMeanRate()).append(", 1mRate=").append(meter.getOneMinuteRate()).append(", 5mRate=").append(meter.getFiveMinuteRate()).append(", 15mRate=").append(meter.getFifteenMinuteRate()).append(LINE_SEPARATOR);
        }
        builder.append(LINE_SEPARATOR).append("-- Histograms -----------------------------------------------------------------").append(LINE_SEPARATOR);
        for (Map.Entry metric : this.metricRegistry.getHistograms().entrySet()) {
            Snapshot stats = ((Histogram)metric.getValue()).getSnapshot();
            builder.append(metric.getValue()).append(": count=").append(stats.size()).append(", min=").append(stats.getMin()).append(", max=").append(stats.getMax()).append(", mean=").append(stats.getMean()).append(", stddev=").append(stats.getStdDev()).append(", p75=").append(stats.get75thPercentile()).append(", p95=").append(stats.get95thPercentile()).append(", p98=").append(stats.get98thPercentile()).append(", p99=").append(stats.get99thPercentile()).append(", p999=").append(stats.get999thPercentile()).append(LINE_SEPARATOR);
        }
        builder.append(LINE_SEPARATOR).append("=========================== Finished metrics report ===========================").append(LINE_SEPARATOR);
        LOGGER.info(builder.toString());
    }

    public void close() {
    }

    public String getReporterType() {
        return TYPE_SLF4J;
    }
}

