/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.model.graph.edge.impl;

import com.antgroup.geaflow.model.graph.edge.EdgeDirection;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import java.util.Objects;

public class ValueEdge<K, EV>
implements IEdge<K, EV> {
    private K srcId;
    private K targetId;
    private EdgeDirection direction;
    private EV value;

    public ValueEdge() {
    }

    public ValueEdge(K srcId, K targetId) {
        this(srcId, targetId, null);
    }

    public ValueEdge(K srcId, K targetId, EV value) {
        this(srcId, targetId, value, EdgeDirection.OUT);
    }

    public ValueEdge(K srcId, K targetId, EV value, EdgeDirection edgeDirection) {
        this.srcId = srcId;
        this.targetId = targetId;
        this.direction = edgeDirection;
        this.value = value;
    }

    @Override
    public K getSrcId() {
        return this.srcId;
    }

    @Override
    public void setSrcId(K srcId) {
        this.srcId = srcId;
    }

    @Override
    public K getTargetId() {
        return this.targetId;
    }

    @Override
    public void setTargetId(K targetId) {
        this.targetId = targetId;
    }

    @Override
    public IEdge<K, EV> reverse() {
        return new ValueEdge<K, EV>(this.targetId, this.srcId, this.value);
    }

    @Override
    public EV getValue() {
        return this.value;
    }

    @Override
    public EdgeDirection getDirect() {
        return this.direction;
    }

    @Override
    public IEdge<K, EV> withValue(EV value) {
        this.value = value;
        return this;
    }

    @Override
    public void setDirect(EdgeDirection direction) {
        this.direction = direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueEdge that = (ValueEdge)o;
        return Objects.equals(this.srcId, that.srcId) && Objects.equals(this.targetId, that.targetId) && this.direction == that.direction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.srcId, this.targetId, this.direction});
    }

    public String toString() {
        return "ValueEdge{srcId=" + this.srcId + ", targetId=" + this.targetId + ", direction=" + (Object)((Object)this.direction) + ", value=" + this.value + '}';
    }
}

