/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.model.graph.message;

import com.antgroup.geaflow.model.graph.message.IGraphMessage;
import java.util.List;

public class ListGraphMessage<K, MESSAGE>
implements IGraphMessage<K, MESSAGE> {
    private final K targetVId;
    private final List<MESSAGE> messages;
    private final int size;
    private int idx;

    public ListGraphMessage(K targetVId, List<MESSAGE> messages) {
        this.targetVId = targetVId;
        this.messages = messages;
        this.size = this.messages.size();
        this.idx = 0;
    }

    public List<MESSAGE> getMessages() {
        return this.messages;
    }

    @Override
    public K getTargetVId() {
        return this.targetVId;
    }

    @Override
    public boolean hasNext() {
        return this.idx < this.size;
    }

    @Override
    public MESSAGE next() {
        MESSAGE message = this.messages.get(this.idx);
        ++this.idx;
        return message;
    }

    public String toString() {
        return "ListGraphMessage{targetVId=" + this.targetVId + ", messages=" + this.messages + '}';
    }
}

