/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.model.graph.message.encoder;

import com.antgroup.geaflow.common.encoder.Encoders;
import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.model.graph.message.ListGraphMessage;
import com.antgroup.geaflow.model.graph.message.encoder.AbstractGraphMessageEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ListGraphMessageEncoder<K, M>
extends AbstractGraphMessageEncoder<K, M, ListGraphMessage<K, M>> {
    public ListGraphMessageEncoder(IEncoder<K> keyEncoder, IEncoder<M> msgEncoder) {
        super(keyEncoder, msgEncoder);
    }

    @Override
    public void doEncode(ListGraphMessage<K, M> data, OutputStream outputStream) throws IOException {
        this.keyEncoder.encode(data.getTargetVId(), outputStream);
        List<M> messages = data.getMessages();
        Encoders.INTEGER.encode((Object)messages.size(), outputStream);
        for (M msg : messages) {
            this.msgEncoder.encode(msg, outputStream);
        }
    }

    public ListGraphMessage<K, M> decode(InputStream inputStream) throws IOException {
        Object vid = this.keyEncoder.decode(inputStream);
        int size = (Integer)Encoders.INTEGER.decode(inputStream);
        ArrayList<Object> messages = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object msg = this.msgEncoder.decode(inputStream);
            messages.add(msg);
        }
        return new ListGraphMessage(vid, messages);
    }
}

