/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.model.graph.meta;

import com.antgroup.geaflow.common.schema.ISchema;
import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.model.graph.meta.GraphElementSchemaFactory;
import com.antgroup.geaflow.model.graph.meta.IGraphElementMeta;
import java.util.function.Supplier;

public abstract class AbstractGraphElementMeta<ELEMENT>
implements IGraphElementMeta<ELEMENT> {
    private final byte graphElementId;
    private final Class<ELEMENT> elementClass;
    private final Supplier<ELEMENT> elementConstruct;
    private final Class<?> propertyClass;
    private final ISchema primitiveSchema;

    public AbstractGraphElementMeta(byte graphElementId, IType keyType, Class<ELEMENT> elementClass, Supplier<ELEMENT> elementConstruct, Class<?> propertyClass) {
        this.graphElementId = graphElementId;
        this.elementClass = elementClass;
        this.elementConstruct = elementConstruct;
        this.propertyClass = propertyClass;
        this.primitiveSchema = GraphElementSchemaFactory.newSchema(keyType, elementClass);
    }

    @Override
    public byte getGraphElementId() {
        return this.graphElementId;
    }

    @Override
    public Class<ELEMENT> getGraphElementClass() {
        return this.elementClass;
    }

    @Override
    public Supplier<ELEMENT> getGraphElementConstruct() {
        return this.elementConstruct;
    }

    @Override
    public ISchema getGraphMeta() {
        return this.primitiveSchema;
    }

    @Override
    public Class<?> getPropertyClass() {
        return this.propertyClass;
    }
}

