/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.model.graph.meta;

import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.model.graph.IGraphElementWithLabelField;
import com.antgroup.geaflow.model.graph.IGraphElementWithTimeField;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.meta.AbstractGraphElementMeta;
import com.antgroup.geaflow.model.graph.meta.GraphFieldSerializers;
import com.antgroup.geaflow.model.graph.meta.IGraphElementMeta;
import com.antgroup.geaflow.model.graph.meta.IGraphFieldSerializer;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class GraphElementMetas {
    private static final ThreadLocal<Map<Class<?>, IGraphElementMeta<?>>> META_CACHE = ThreadLocal.withInitial(HashMap::new);

    public static IGraphElementMeta<?> getMeta(IType keyType, Class<?> elementClass, Supplier<?> elementConstruct, Class<?> propertyClass) {
        Map<Class<?>, IGraphElementMeta<?>> map = META_CACHE.get();
        return map.computeIfAbsent(elementClass, k -> GraphElementMetas.newGraphElementMeta(keyType, elementClass, elementConstruct, propertyClass));
    }

    public static void clearCache() {
        META_CACHE.remove();
    }

    private static IGraphElementMeta<?> newGraphElementMeta(IType keyType, Class<?> elementClass, Supplier<?> elementConstruct, Class<?> propertyClass) {
        GraphElementFlag flag = GraphElementFlag.build(elementClass);
        byte graphElementId = flag.toGraphElementId();
        if (flag.isLabeled()) {
            return new LabelElementMeta(graphElementId, keyType, elementClass, elementConstruct, propertyClass);
        }
        if (flag.isTimed()) {
            return new TimeElementMeta(graphElementId, keyType, elementClass, elementConstruct, propertyClass);
        }
        if (flag.isLabeledAndTimed()) {
            return new LabelTimeElementMeta(graphElementId, keyType, elementClass, elementConstruct, propertyClass);
        }
        return new IdElementMeta(graphElementId, keyType, elementClass, elementConstruct, propertyClass);
    }

    public static class LabelTimeElementMeta<ELEMENT extends IGraphElementWithLabelField & IGraphElementWithTimeField>
    extends AbstractGraphElementMeta<ELEMENT> {
        public LabelTimeElementMeta(byte graphElementId, IType keyType, Class<ELEMENT> elementClass, Supplier<ELEMENT> elementConstruct, Class<?> propertyClass) {
            super(graphElementId, keyType, elementClass, elementConstruct, propertyClass);
        }

        @Override
        public IGraphFieldSerializer<ELEMENT> getGraphFieldSerializer() {
            return GraphFieldSerializers.LabelTimeFieldSerializer.INSTANCE;
        }
    }

    public static class TimeElementMeta<ELEMENT extends IGraphElementWithTimeField>
    extends AbstractGraphElementMeta<ELEMENT> {
        public TimeElementMeta(byte graphElementId, IType keyType, Class<?> elementClass, Supplier<ELEMENT> elementConstruct, Class<?> propertyClass) {
            super(graphElementId, keyType, elementClass, elementConstruct, propertyClass);
        }

        @Override
        public IGraphFieldSerializer<ELEMENT> getGraphFieldSerializer() {
            return GraphFieldSerializers.TimeFieldSerializer.INSTANCE;
        }
    }

    public static class LabelElementMeta<ELEMENT extends IGraphElementWithLabelField>
    extends AbstractGraphElementMeta<ELEMENT> {
        public LabelElementMeta(byte graphElementId, IType keyType, Class<ELEMENT> elementClass, Supplier<ELEMENT> elementConstruct, Class<?> propertyClass) {
            super(graphElementId, keyType, elementClass, elementConstruct, propertyClass);
        }

        @Override
        public IGraphFieldSerializer<ELEMENT> getGraphFieldSerializer() {
            return GraphFieldSerializers.LabelFieldSerializer.INSTANCE;
        }
    }

    public static class IdElementMeta<ELEMENT>
    extends AbstractGraphElementMeta<ELEMENT> {
        public IdElementMeta(byte graphElementId, IType keyType, Class<ELEMENT> elementClass, Supplier<ELEMENT> elementConstruct, Class<?> propertyClass) {
            super(graphElementId, keyType, elementClass, elementConstruct, propertyClass);
        }

        @Override
        public IGraphFieldSerializer<ELEMENT> getGraphFieldSerializer() {
            return GraphFieldSerializers.IdFieldSerializer.INSTANCE;
        }
    }

    public static class GraphElementFlag {
        private static final byte MASK_LABEL = 1;
        private static final byte MASK_TIME = 2;
        private byte flag = 0;

        public void markLabeled() {
            this.flag = (byte)(this.flag | 1);
        }

        public void markTimed() {
            this.flag = (byte)(this.flag | 2);
        }

        public boolean isLabeled() {
            return (this.flag & 1) > 0 && (this.flag & 2) == 0;
        }

        public boolean isTimed() {
            return (this.flag & 1) == 0 && (this.flag & 2) > 0;
        }

        public boolean isLabeledAndTimed() {
            return (this.flag & 1) > 0 && (this.flag & 2) > 0;
        }

        public byte toGraphElementId() {
            return this.flag;
        }

        public static GraphElementFlag build(Class<?> elementClass) {
            if (!IVertex.class.isAssignableFrom(elementClass) && !IEdge.class.isAssignableFrom(elementClass)) {
                String msg = "unrecognized graph element class: " + elementClass.getCanonicalName();
                throw new GeaflowRuntimeException(RuntimeErrors.INST.undefinedError(msg));
            }
            GraphElementFlag tag = new GraphElementFlag();
            if (IGraphElementWithLabelField.class.isAssignableFrom(elementClass)) {
                tag.markLabeled();
            }
            if (IGraphElementWithTimeField.class.isAssignableFrom(elementClass)) {
                tag.markTimed();
            }
            return tag;
        }
    }
}

