/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.model.graph.message.encoder;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.common.encoder.impl.AbstractEncoder;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.model.graph.message.IGraphMessage;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractGraphMessageEncoder<K, M, GRAPHMESSAGE extends IGraphMessage<K, M>>
extends AbstractEncoder<GRAPHMESSAGE> {
    protected final IEncoder<K> keyEncoder;
    protected final IEncoder<M> msgEncoder;

    public AbstractGraphMessageEncoder(IEncoder<K> keyEncoder, IEncoder<M> msgEncoder) {
        this.keyEncoder = keyEncoder;
        this.msgEncoder = msgEncoder;
    }

    public void init(Configuration config) {
        this.keyEncoder.init(config);
        this.msgEncoder.init(config);
    }

    public void encode(GRAPHMESSAGE data, OutputStream outputStream) throws IOException {
        if (data == null) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.shuffleSerializeError("graph message can not be null"));
        }
        this.doEncode(data, outputStream);
    }

    public abstract void doEncode(GRAPHMESSAGE var1, OutputStream var2) throws IOException;
}

