/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.model.graph.meta;

import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.model.graph.IGraphElementWithLabelField;
import com.antgroup.geaflow.model.graph.IGraphElementWithTimeField;
import com.antgroup.geaflow.model.graph.meta.GraphFiledName;
import com.antgroup.geaflow.model.graph.meta.IGraphFieldSerializer;

public class GraphFieldSerializers {
    private static String keyTypeErrMsg(Class<?> clazz, String key) {
        return String.format("unrecognized key [%s] of [%s]", key, clazz.getCanonicalName());
    }

    public static class LabelTimeFieldSerializer<ELEMENT extends IGraphElementWithLabelField & IGraphElementWithTimeField>
    implements IGraphFieldSerializer<ELEMENT> {
        public static final LabelTimeFieldSerializer INSTANCE = new LabelTimeFieldSerializer();

        @Override
        public Object getValue(ELEMENT element, GraphFiledName field) {
            switch (field) {
                case LABEL: {
                    return element.getLabel();
                }
                case TIME: {
                    return ((IGraphElementWithTimeField)element).getTime();
                }
            }
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(GraphFieldSerializers.keyTypeErrMsg(element.getClass(), field.name())));
        }

        @Override
        public void setValue(ELEMENT element, GraphFiledName field, Object value) {
            switch (field) {
                case LABEL: {
                    element.setLabel((String)value);
                    return;
                }
                case TIME: {
                    ((IGraphElementWithTimeField)element).setTime((Long)value);
                    return;
                }
            }
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(GraphFieldSerializers.keyTypeErrMsg(element.getClass(), field.name())));
        }
    }

    public static class TimeFieldSerializer<ELEMENT extends IGraphElementWithTimeField>
    implements IGraphFieldSerializer<ELEMENT> {
        public static final TimeFieldSerializer INSTANCE = new TimeFieldSerializer();

        @Override
        public Object getValue(ELEMENT element, GraphFiledName field) {
            if (field == GraphFiledName.TIME) {
                return element.getTime();
            }
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(GraphFieldSerializers.keyTypeErrMsg(element.getClass(), field.name())));
        }

        @Override
        public void setValue(ELEMENT vertex, GraphFiledName field, Object value) {
            if (field != GraphFiledName.TIME) {
                throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(GraphFieldSerializers.keyTypeErrMsg(vertex.getClass(), field.name())));
            }
            vertex.setTime((Long)value);
        }
    }

    public static class LabelFieldSerializer<ELEMENT extends IGraphElementWithLabelField>
    implements IGraphFieldSerializer<ELEMENT> {
        public static final LabelFieldSerializer INSTANCE = new LabelFieldSerializer();

        @Override
        public Object getValue(ELEMENT element, GraphFiledName field) {
            if (field == GraphFiledName.LABEL) {
                return element.getLabel();
            }
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(GraphFieldSerializers.keyTypeErrMsg(element.getClass(), field.name())));
        }

        @Override
        public void setValue(ELEMENT element, GraphFiledName field, Object value) {
            if (field != GraphFiledName.LABEL) {
                throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(GraphFieldSerializers.keyTypeErrMsg(element.getClass(), field.name())));
            }
            element.setLabel((String)value);
        }
    }

    public static class IdFieldSerializer<ELEMENT>
    implements IGraphFieldSerializer<ELEMENT> {
        public static final IdFieldSerializer INSTANCE = new IdFieldSerializer();

        @Override
        public Object getValue(ELEMENT element, GraphFiledName field) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(GraphFieldSerializers.keyTypeErrMsg(element.getClass(), field.name())));
        }

        @Override
        public void setValue(ELEMENT element, GraphFiledName field, Object value) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(GraphFieldSerializers.keyTypeErrMsg(element.getClass(), field.name())));
        }
    }
}

