/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.model.graph.vertex.impl;

import com.antgroup.geaflow.model.graph.IGraphElementWithLabelField;
import com.antgroup.geaflow.model.graph.IGraphElementWithTimeField;
import com.antgroup.geaflow.model.graph.vertex.impl.IDVertex;
import com.antgroup.geaflow.model.graph.vertex.impl.ValueLabelTimeVertex;
import com.antgroup.geaflow.model.graph.vertex.impl.ValueVertex;
import java.util.Objects;

public class IDLabelTimeVertex<K>
extends IDVertex<K>
implements IGraphElementWithLabelField,
IGraphElementWithTimeField {
    private String label;
    private long time;

    public IDLabelTimeVertex() {
    }

    public IDLabelTimeVertex(K id) {
        super(id);
    }

    public IDLabelTimeVertex(K id, String label, long time) {
        super(id);
        this.label = label;
        this.time = time;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public ValueVertex<K, Object> withValue(Object value) {
        return new ValueLabelTimeVertex(this.getId(), value, this.label, this.time);
    }

    @Override
    public IDVertex<K> withLabel(String label) {
        this.label = label;
        return this;
    }

    @Override
    public IDVertex<K> withTime(long time) {
        this.time = time;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        IDLabelTimeVertex that = (IDLabelTimeVertex)o;
        return this.time == that.time && Objects.equals(this.label, that.label);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.label, this.time);
    }
}

