/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.model.graph.vertex.impl;

import com.antgroup.geaflow.model.graph.IGraphElementWithTimeField;
import com.antgroup.geaflow.model.graph.vertex.impl.IDLabelTimeVertex;
import com.antgroup.geaflow.model.graph.vertex.impl.IDVertex;
import com.antgroup.geaflow.model.graph.vertex.impl.ValueTimeVertex;
import com.antgroup.geaflow.model.graph.vertex.impl.ValueVertex;
import java.util.Objects;

public class IDTimeVertex<K>
extends IDVertex<K>
implements IGraphElementWithTimeField {
    private long time;

    public IDTimeVertex() {
    }

    public IDTimeVertex(K id) {
        super(id);
    }

    public IDTimeVertex(K id, long time) {
        super(id);
        this.time = time;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public ValueVertex<K, Object> withValue(Object value) {
        return new ValueTimeVertex(this.getId(), value, this.time);
    }

    @Override
    public IDVertex<K> withLabel(String label) {
        return new IDLabelTimeVertex(this.getId(), label, this.time);
    }

    @Override
    public IDTimeVertex<K> withTime(long time) {
        this.time = time;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        IDTimeVertex that = (IDTimeVertex)o;
        return this.time == that.time;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.time);
    }
}

