/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.model.graph.vertex.impl;

import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.model.graph.vertex.impl.ValueLabelVertex;
import com.antgroup.geaflow.model.graph.vertex.impl.ValueTimeVertex;
import java.util.Objects;

public class ValueVertex<K, VV>
implements IVertex<K, VV> {
    private K id;
    private VV value;

    public ValueVertex() {
    }

    public ValueVertex(K id) {
        this.id = id;
    }

    public ValueVertex(K id, VV value) {
        this.id = id;
        this.value = value;
    }

    @Override
    public K getId() {
        return this.id;
    }

    @Override
    public void setId(K id) {
        this.id = id;
    }

    @Override
    public VV getValue() {
        return this.value;
    }

    @Override
    public ValueVertex<K, VV> withValue(VV value) {
        this.value = value;
        return this;
    }

    @Override
    public ValueVertex<K, VV> withLabel(String label) {
        return new ValueLabelVertex<K, VV>(this.id, this.value, label);
    }

    @Override
    public ValueVertex<K, VV> withTime(long time) {
        return new ValueTimeVertex<K, VV>(this.id, this.value, time);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueVertex idVertex = (ValueVertex)o;
        return Objects.equals(this.id, idVertex.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return String.format("ValueVertex(vertexId:%s, value:%s)", this.id, this.value);
    }

    public int compareTo(Object o) {
        ValueVertex vertex = (ValueVertex)o;
        if (this.id instanceof Comparable) {
            return ((Comparable)this.id).compareTo(vertex.getId());
        }
        return Integer.valueOf(this.hashCode()).compareTo(vertex.hashCode());
    }
}

