/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.base.window;

import com.antgroup.geaflow.api.function.Function;
import com.antgroup.geaflow.operator.OpArgs;
import com.antgroup.geaflow.operator.base.window.AbstractStreamOperator;
import com.antgroup.geaflow.operator.base.window.OneInputOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOneInputOperator<T, FUNC extends Function>
extends AbstractStreamOperator<FUNC>
implements OneInputOperator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOneInputOperator.class);

    public AbstractOneInputOperator() {
        this.opArgs.setOpType(OpArgs.OpType.ONE_INPUT);
    }

    public AbstractOneInputOperator(FUNC func) {
        super(func);
        this.opArgs.setOpType(OpArgs.OpType.ONE_INPUT);
    }

    @Override
    public void processElement(T value) throws Exception {
        this.ticToc.ticNano();
        this.process(value);
        this.opRtHistogram.update(this.ticToc.tocNano() / 1000L);
        this.opInputMeter.mark();
    }

    protected abstract void process(T var1) throws Exception;
}

