/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.impl.graph.compute.statical;

import com.antgroup.geaflow.api.graph.base.algo.VertexCentricAlgo;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.meta.GraphMeta;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.AbstractGraphVertexCentricOp;
import com.antgroup.geaflow.state.DataModel;
import com.antgroup.geaflow.state.descriptor.GraphStateDescriptor;
import com.antgroup.geaflow.view.graph.GraphViewDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStaticGraphVertexCentricOp<K, VV, EV, M, FUNC extends VertexCentricAlgo<K, VV, EV, M>>
extends AbstractGraphVertexCentricOp<K, VV, EV, M, FUNC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStaticGraphVertexCentricOp.class);

    public AbstractStaticGraphVertexCentricOp(GraphViewDesc graphViewDesc, FUNC func) {
        super(graphViewDesc, func);
    }

    @Override
    public void addVertex(IVertex<K, VV> vertex) {
        if (this.enableDebug) {
            LOGGER.info("taskId:{} add vertex:{}", (Object)this.taskId, vertex);
        }
        this.graphState.staticGraph().V().add(vertex);
        this.opInputMeter.mark();
    }

    @Override
    public void addEdge(IEdge<K, EV> edge) {
        if (this.enableDebug) {
            LOGGER.info("taskId:{} add edge:{}", (Object)this.taskId, edge);
        }
        this.graphState.staticGraph().E().add(edge);
        this.opInputMeter.mark();
    }

    @Override
    protected GraphStateDescriptor<K, VV, EV> buildGraphStateDesc(String name) {
        GraphStateDescriptor desc = super.buildGraphStateDesc(name);
        desc.withDataModel(this.graphViewDesc.isStatic() ? DataModel.STATIC_GRAPH : DataModel.DYNAMIC_GRAPH);
        if (this.graphViewDesc.getGraphMetaType() != null) {
            desc.withGraphMeta(new GraphMeta(this.graphViewDesc.getGraphMetaType()));
        }
        return desc;
    }
}

