/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.base;

import com.antgroup.geaflow.api.context.RuntimeContext;
import com.antgroup.geaflow.api.function.Function;
import com.antgroup.geaflow.api.function.RichFunction;
import com.antgroup.geaflow.api.function.RichWindowFunction;
import com.antgroup.geaflow.api.trait.CancellableTrait;
import com.antgroup.geaflow.collector.AbstractCollector;
import com.antgroup.geaflow.collector.ICollector;
import com.antgroup.geaflow.collector.chain.OpChainCollector;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.metrics.common.MetricGroupRegistry;
import com.antgroup.geaflow.metrics.common.MetricNameFormatter;
import com.antgroup.geaflow.metrics.common.api.BlackHoleMetricGroup;
import com.antgroup.geaflow.metrics.common.api.Histogram;
import com.antgroup.geaflow.metrics.common.api.Meter;
import com.antgroup.geaflow.metrics.common.api.MetricGroup;
import com.antgroup.geaflow.operator.OpArgs;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.utils.TicToc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperator<FUNC extends Function>
implements Operator,
CancellableTrait {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOperator.class);
    private static final String ANONYMOUS = "Anonymous";
    private static final String EMPTY = "";
    protected OpArgs opArgs;
    protected FUNC function;
    protected List<ICollector> collectors;
    protected List<Operator> subOperatorList = new ArrayList<Operator>();
    protected Map<Integer, String> outputTags = new HashMap<Integer, String>();
    protected boolean enableDebug = false;
    protected Operator.OpContext opContext;
    protected RuntimeContext runtimeContext;
    protected MetricGroup metricGroup;
    protected TicToc ticToc;
    protected Meter opInputMeter;
    protected Meter opOutputMeter;
    protected Histogram opRtHistogram;

    public AbstractOperator() {
        this.opArgs = new OpArgs();
    }

    public AbstractOperator(FUNC function) {
        this();
        this.function = function;
    }

    @Override
    public void open(Operator.OpContext opContext) {
        this.opContext = opContext;
        Map opConfig = this.opArgs.getConfig();
        this.runtimeContext = opContext.getRuntimeContext().clone(opConfig);
        boolean enableDetailMetric = this.runtimeContext.getConfiguration().getBoolean(ExecutionConfigKeys.ENABLE_DETAIL_METRIC);
        this.metricGroup = enableDetailMetric ? MetricGroupRegistry.getInstance().getMetricGroup("framework") : BlackHoleMetricGroup.INSTANCE;
        this.opInputMeter = this.metricGroup.meter(MetricNameFormatter.inputTpsMetricName(this.getClass(), (int)this.opArgs.getOpId()));
        this.opOutputMeter = this.metricGroup.meter(MetricNameFormatter.outputTpsMetricName(this.getClass(), (int)this.opArgs.getOpId()));
        this.opRtHistogram = this.metricGroup.histogram(MetricNameFormatter.rtMetricName(this.getClass(), (int)this.opArgs.getOpId()));
        this.ticToc = new TicToc();
        LOGGER.info("{} open,enableDebug:{}", (Object)this.getClass().getSimpleName(), (Object)this.enableDebug);
        this.collectors = new ArrayList<ICollector>();
        if (this.function instanceof RichFunction) {
            ((RichFunction)this.function).open(this.runtimeContext);
        }
        for (Operator subOperator : this.subOperatorList) {
            DefaultOpContext subOpContext = new DefaultOpContext(opContext.getCollectors(), opContext.getRuntimeContext());
            subOperator.open(subOpContext);
            OpChainCollector chainCollector = new OpChainCollector(this.opArgs.getOpId(), subOperator);
            this.collectors.add(chainCollector);
        }
        this.collectors.addAll(opContext.getCollectors().stream().filter(collector -> collector.getId() == this.opArgs.getOpId()).collect(Collectors.toList()));
        int size = this.collectors.size();
        for (int i = 0; i < size; ++i) {
            ICollector collector2 = this.collectors.get(i);
            collector2.setUp(this.runtimeContext);
            if (!(collector2 instanceof AbstractCollector)) continue;
            ((AbstractCollector)collector2).setOutputMetric(this.opOutputMeter);
        }
    }

    @Override
    public void close() {
        if (this.function instanceof RichFunction) {
            ((RichFunction)this.function).close();
        }
        for (Operator subOperator : this.subOperatorList) {
            subOperator.close();
        }
    }

    @Override
    public void finish() {
        if (this.function instanceof RichWindowFunction) {
            ((RichWindowFunction)this.function).finish();
        }
        int size = this.collectors.size();
        for (int i = 0; i < size; ++i) {
            this.collectors.get(i).finish();
        }
        for (Operator operator : this.subOperatorList) {
            operator.finish();
        }
    }

    public void cancel() {
        if (this.function instanceof CancellableTrait) {
            ((CancellableTrait)this.function).cancel();
        }
    }

    public OpArgs getOpArgs() {
        return this.opArgs;
    }

    public List<Operator> getNextOperators() {
        return this.subOperatorList;
    }

    public void addNextOperator(Operator operator) {
        this.subOperatorList.add(operator);
    }

    public Map<Integer, String> getOutputTags() {
        return this.outputTags;
    }

    public FUNC getFunction() {
        return this.function;
    }

    public void setFunction(FUNC function) {
        this.function = function;
    }

    public Operator.OpContext getOpContext() {
        return this.opContext;
    }

    public String toString() {
        return this.getOperatorString(0);
    }

    public String getOperatorString(int level) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            str.append("\t");
        }
        str.append(this.getClass().getSimpleName()).append("-").append(this.getIdentify()).append("-").append(this.getFunctionString());
        for (Operator subOperator : this.subOperatorList) {
            str.append(((AbstractOperator)subOperator).getOperatorString(level + 1));
        }
        return str.toString();
    }

    public String getIdentify() {
        if (StringUtils.isNotBlank((CharSequence)this.opArgs.getOpName())) {
            return this.opArgs.getOpName();
        }
        return String.valueOf(this.opArgs.getOpId());
    }

    private String getFunctionString() {
        if (this.function != null) {
            if (this.function.getClass().getSimpleName().length() == 0) {
                return ANONYMOUS;
            }
            return this.function.getClass().getSimpleName();
        }
        return EMPTY;
    }

    public static class DefaultOpContext
    implements Operator.OpContext {
        private final RuntimeContext runtimeContext;
        private final List<ICollector> collectors;

        public DefaultOpContext(List<ICollector> collectors, RuntimeContext runtimeContext) {
            this.runtimeContext = runtimeContext;
            this.collectors = collectors;
        }

        @Override
        public List<ICollector> getCollectors() {
            return this.collectors;
        }

        @Override
        public RuntimeContext getRuntimeContext() {
            return this.runtimeContext;
        }
    }
}

