/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.impl.graph.algo.vc;

import com.antgroup.geaflow.api.function.iterator.RichIteratorFunction;
import com.antgroup.geaflow.api.graph.base.algo.VertexCentricAlgo;
import com.antgroup.geaflow.api.graph.function.vc.VertexCentricCombineFunction;
import com.antgroup.geaflow.api.partition.graph.edge.IGraphVCPartition;
import com.antgroup.geaflow.collector.AbstractCollector;
import com.antgroup.geaflow.collector.ICollector;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.config.keys.FrameworkConfigKeys;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.context.AbstractRuntimeContext;
import com.antgroup.geaflow.metrics.common.MetricNameFormatter;
import com.antgroup.geaflow.metrics.common.api.Meter;
import com.antgroup.geaflow.model.graph.message.IGraphMessage;
import com.antgroup.geaflow.model.record.RecordArgs;
import com.antgroup.geaflow.operator.OpArgs;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.base.AbstractOperator;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.IGraphVertexCentricOp;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.msgbox.GraphMsgBoxFactory;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.msgbox.IGraphMsgBox;
import com.antgroup.geaflow.operator.impl.iterator.IteratorOperator;
import com.antgroup.geaflow.state.GraphState;
import com.antgroup.geaflow.state.StateFactory;
import com.antgroup.geaflow.state.descriptor.GraphStateDescriptor;
import com.antgroup.geaflow.state.graph.StateMode;
import com.antgroup.geaflow.state.manage.LoadOption;
import com.antgroup.geaflow.utils.keygroup.IKeyGroupAssigner;
import com.antgroup.geaflow.utils.keygroup.KeyGroup;
import com.antgroup.geaflow.utils.keygroup.KeyGroupAssignerFactory;
import com.antgroup.geaflow.utils.keygroup.KeyGroupAssignment;
import com.antgroup.geaflow.view.IViewDesc;
import com.antgroup.geaflow.view.graph.GraphViewDesc;
import com.antgroup.geaflow.view.meta.ViewMetaBookKeeper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphVertexCentricOp<K, VV, EV, M, FUNC extends VertexCentricAlgo<K, VV, EV, M>>
extends AbstractOperator<FUNC>
implements IGraphVertexCentricOp<K, VV, EV, M>,
IteratorOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGraphVertexCentricOp.class);
    protected int taskId;
    protected VertexCentricCombineFunction<M> msgCombineFunction;
    protected IGraphVCPartition<K> graphVCPartition;
    protected final GraphViewDesc graphViewDesc;
    protected long maxIterations;
    protected long iterations;
    protected long windowId;
    protected KeyGroup keyGroup;
    protected KeyGroup taskKeyGroup;
    protected GraphState<K, VV, EV> graphState;
    protected IGraphMsgBox<K, M> graphMsgBox;
    protected boolean shareEnable;
    protected Map<String, ICollector> collectorMap;
    protected ICollector<IGraphMessage<K, M>> messageCollector;
    protected Meter msgMeter;

    public AbstractGraphVertexCentricOp(GraphViewDesc graphViewDesc, FUNC func) {
        super(func);
        this.graphViewDesc = graphViewDesc;
        this.maxIterations = func.getMaxIterationCount();
        this.opArgs.setChainStrategy(OpArgs.ChainStrategy.NEVER);
    }

    @Override
    public void open(Operator.OpContext opContext) {
        super.open(opContext);
        this.msgCombineFunction = ((VertexCentricAlgo)this.function).getCombineFunction();
        this.graphVCPartition = ((VertexCentricAlgo)this.function).getGraphPartition();
        this.windowId = this.runtimeContext.getWindowId();
        this.msgMeter = this.metricGroup.meter(MetricNameFormatter.iterationMsgMetricName(this.getClass(), (int)this.opArgs.getOpId()));
        this.shareEnable = this.runtimeContext.getConfiguration().getBoolean(FrameworkConfigKeys.SERVICE_SHARE_ENABLE);
        GraphStateDescriptor<K, VV, EV> desc = this.buildGraphStateDesc(this.opArgs.getOpName());
        desc.withMetricGroup(this.runtimeContext.getMetric());
        this.graphState = StateFactory.buildGraphState(desc, (Configuration)this.runtimeContext.getConfiguration());
        LOGGER.info("ThreadId {}, open graphState", (Object)Thread.currentThread().getId());
        if (!this.shareEnable) {
            this.taskKeyGroup = this.keyGroup;
            LOGGER.info("recovery graph state {}", this.graphState);
            this.recover();
        } else {
            this.load();
            LOGGER.info("processIndex {} taskIndex {} load shard {}, load graph state {}", new Object[]{this.runtimeContext.getTaskArgs().getProcessIndex(), this.runtimeContext.getTaskArgs().getTaskIndex(), this.keyGroup, this.graphState});
        }
        this.collectorMap = new HashMap<String, ICollector>();
        for (ICollector collector : this.collectors) {
            this.collectorMap.put(collector.getTag(), collector);
        }
        this.messageCollector = this.collectorMap.get(RecordArgs.GraphRecordNames.Message.name());
        if (this.messageCollector instanceof AbstractCollector) {
            ((AbstractCollector)this.messageCollector).setOutputMetric(this.msgMeter);
        }
        this.graphMsgBox = GraphMsgBoxFactory.buildMessageBox(this.messageCollector, this.msgCombineFunction);
    }

    protected GraphStateDescriptor<K, VV, EV> buildGraphStateDesc(String name) {
        this.taskId = this.runtimeContext.getTaskArgs().getTaskId();
        int containerNum = this.runtimeContext.getConfiguration().getInteger(ExecutionConfigKeys.CONTAINER_NUM);
        int processIndex = this.runtimeContext.getTaskArgs().getProcessIndex();
        int taskIndex = this.shareEnable ? processIndex : this.runtimeContext.getTaskArgs().getTaskIndex();
        int taskPara = this.shareEnable ? containerNum : this.runtimeContext.getTaskArgs().getParallelism();
        IViewDesc.BackendType backendType = this.graphViewDesc.getBackend();
        GraphStateDescriptor desc = GraphStateDescriptor.build((String)this.graphViewDesc.getName(), (String)backendType.name());
        int maxPara = this.graphViewDesc.getShardNum();
        Preconditions.checkArgument((taskPara <= maxPara ? 1 : 0) != 0, (Object)String.format("task parallelism '%s' must be <= shard num(max parallelism) '%s'", taskPara, maxPara));
        this.keyGroup = KeyGroupAssignment.computeKeyGroupRangeForOperatorIndex((int)maxPara, (int)taskPara, (int)taskIndex);
        IKeyGroupAssigner keyGroupAssigner = KeyGroupAssignerFactory.createKeyGroupAssigner((KeyGroup)this.keyGroup, (int)taskIndex, (int)maxPara);
        desc.withKeyGroup(this.keyGroup);
        desc.withKeyGroupAssigner(keyGroupAssigner);
        if (this.shareEnable) {
            LOGGER.info("enable state singleton");
            desc.withSingleton();
            desc.withStateMode(StateMode.RDONLY);
        }
        LOGGER.info("opName:{} taskId:{} taskIndex:{} keyGroup:{} containerNum:{} processIndex: {} real taskIndex:{}", new Object[]{this.opArgs.getOpName(), this.taskId, taskIndex, desc.getKeyGroup(), containerNum, processIndex, this.runtimeContext.getTaskArgs().getTaskIndex()});
        return desc;
    }

    @Override
    public void processMessage(IGraphMessage<K, M> graphMessage) {
        if (this.enableDebug) {
            LOGGER.info("taskId:{} windowId:{} Iteration:{} add message:{}", new Object[]{this.taskId, this.windowId, this.iterations, graphMessage});
        }
        Object vertexId = graphMessage.getTargetVId();
        while (graphMessage.hasNext()) {
            this.graphMsgBox.addInMessages(vertexId, graphMessage.next());
        }
        this.opInputMeter.mark();
    }

    @Override
    public void initIteration(long iterations) {
        this.iterations = iterations;
        this.windowId = this.opContext.getRuntimeContext().getWindowId();
        ((AbstractRuntimeContext)this.runtimeContext).updateWindowId(this.windowId);
        if (this.enableDebug) {
            LOGGER.info("taskId:{} windowId:{} init Iteration:{}", new Object[]{this.taskId, this.windowId, iterations});
        }
        this.iterations = iterations;
        if (this.function instanceof RichIteratorFunction) {
            ((RichIteratorFunction)this.function).initIteration(iterations);
        }
    }

    @Override
    public long getMaxIterationCount() {
        return this.maxIterations;
    }

    @Override
    public void finishIteration(long iteration) {
        this.ticToc.tic();
        this.doFinishIteration(iteration);
        this.metricGroup.histogram(MetricNameFormatter.iterationFinishMetricName(this.getClass(), (int)this.opArgs.getOpId(), (long)iteration)).update(this.ticToc.toc());
    }

    public abstract void doFinishIteration(long var1);

    @Override
    public void close() {
        this.graphMsgBox.clearInBox();
        this.graphMsgBox.clearOutBox();
        if (!this.shareEnable) {
            this.graphState.manage().operate().close();
        }
    }

    protected void recover() {
        LOGGER.info("opName: {} will do recover, windowId: {}", (Object)this.opArgs.getOpName(), (Object)this.windowId);
        long lastCheckPointId = this.getLatestViewVersion();
        if (lastCheckPointId >= 0L) {
            LOGGER.info("opName: {} do recover to state VersionId: {}", (Object)this.opArgs.getOpName(), (Object)lastCheckPointId);
            this.graphState.manage().operate().setCheckpointId(lastCheckPointId);
            this.graphState.manage().operate().recover();
        }
    }

    protected void load() {
        LOGGER.info("opName: {} will do load, windowId: {}", (Object)this.opArgs.getOpName(), (Object)this.windowId);
        long lastCheckPointId = this.getLatestViewVersion();
        long checkPointId = lastCheckPointId < 0L ? 0L : lastCheckPointId;
        LOGGER.info("opName: {} do load, ViewMetaBookKeeper version: {}, checkPointId {}", new Object[]{this.opArgs.getOpName(), lastCheckPointId, checkPointId});
        LoadOption loadOption = LoadOption.of();
        this.taskKeyGroup = KeyGroupAssignment.computeKeyGroupRangeForOperatorIndex((int)this.graphViewDesc.getShardNum(), (int)this.runtimeContext.getTaskArgs().getParallelism(), (int)this.runtimeContext.getTaskArgs().getTaskIndex());
        loadOption.withKeyGroup(this.taskKeyGroup);
        loadOption.withCheckpointId(checkPointId);
        this.graphState.manage().operate().load(loadOption);
        LOGGER.info("opName: {} task key group {} do load successfully", (Object)this.opArgs.getOpName(), (Object)this.taskKeyGroup);
    }

    private long getLatestViewVersion() {
        long lastCheckPointId;
        try {
            ViewMetaBookKeeper keeper = new ViewMetaBookKeeper(this.graphViewDesc.getName(), this.runtimeContext.getConfiguration());
            lastCheckPointId = keeper.getLatestViewVersion(this.graphViewDesc.getName());
            LOGGER.info("opName: {} will do recover or load, ViewMetaBookKeeper version: {}", (Object)this.opArgs.getOpName(), (Object)lastCheckPointId);
        }
        catch (IOException e) {
            throw new GeaflowRuntimeException((Throwable)e);
        }
        return lastCheckPointId;
    }
}

