/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.impl.graph.algo.vc;

import com.antgroup.geaflow.api.graph.base.algo.GraphAggregationAlgo;
import com.antgroup.geaflow.api.graph.base.algo.VertexCentricAlgo;
import com.antgroup.geaflow.api.graph.function.aggregate.VertexCentricAggContextFunction;
import com.antgroup.geaflow.api.graph.function.vc.VertexCentricAggregateFunction;
import com.antgroup.geaflow.collector.AbstractCollector;
import com.antgroup.geaflow.collector.ICollector;
import com.antgroup.geaflow.common.config.ConfigKey;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.metrics.common.MetricGroupRegistry;
import com.antgroup.geaflow.metrics.common.MetricNameFormatter;
import com.antgroup.geaflow.metrics.common.api.BlackHoleMetricGroup;
import com.antgroup.geaflow.metrics.common.api.Meter;
import com.antgroup.geaflow.model.record.RecordArgs;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.AbstractGraphVertexCentricOp;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphVertexCentricOpAggregator<K, VV, EV, M, I, PA, PR, GA, GR, FUNC extends VertexCentricAlgo<K, VV, EV, M>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphVertexCentricOpAggregator.class);
    private AbstractGraphVertexCentricOp<K, VV, EV, M, FUNC> operator;
    private long iteration;
    protected VertexCentricAggregateFunction.IPartialGraphAggFunction<I, PA, PR> partialGraphAggFunction;
    protected PartialAggContextImpl partialAggContextImpl;
    protected PA partialAgg;
    protected PR partialResult;
    protected GR globalResult;
    private ICollector<PR> aggregateCollector;

    public GraphVertexCentricOpAggregator(AbstractGraphVertexCentricOp<K, VV, EV, M, FUNC> operator) {
        this.operator = operator;
    }

    public void open(VertexCentricAggContextFunction<I, GR> aggFunction) {
        this.partialGraphAggFunction = ((GraphAggregationAlgo)((VertexCentricAlgo)this.operator.getFunction())).getAggregateFunction().getPartialAggregation();
        this.partialAggContextImpl = new PartialAggContextImpl();
        this.partialAgg = this.partialGraphAggFunction.create((VertexCentricAggregateFunction.IPartialAggContext)this.partialAggContextImpl);
        VertexCentricAggContextImpl aggContext = new VertexCentricAggContextImpl();
        aggFunction.initContext((VertexCentricAggContextFunction.VertexCentricAggContext)aggContext);
        boolean enableDetailMetric = Configuration.getBoolean((ConfigKey)ExecutionConfigKeys.ENABLE_DETAIL_METRIC, (Map)this.operator.getOpArgs().getConfig());
        BlackHoleMetricGroup metricGroup = enableDetailMetric ? MetricGroupRegistry.getInstance().getMetricGroup("framework") : BlackHoleMetricGroup.INSTANCE;
        Meter aggMeter = metricGroup.meter(MetricNameFormatter.iterationAggMetricName(this.getClass(), (int)this.operator.getOpArgs().getOpId()));
        this.aggregateCollector = this.operator.collectorMap.get(RecordArgs.GraphRecordNames.Aggregate.name());
        if (this.aggregateCollector instanceof AbstractCollector) {
            ((AbstractCollector)this.aggregateCollector).setOutputMetric(aggMeter);
        }
    }

    public void initIteration(long iteration) {
        this.iteration = iteration;
    }

    public void finishIteration(long iteration) {
        if (this.partialResult != null) {
            this.partialGraphAggFunction.finish(this.partialResult);
            LOGGER.info("iterationId:{} partial result :{}", (Object)iteration, this.partialResult);
            this.aggregateCollector.finish();
            this.partialResult = null;
        }
    }

    public void processAggregateResult(GR result) {
        this.globalResult = result;
        this.partialAgg = this.partialGraphAggFunction.create((VertexCentricAggregateFunction.IPartialAggContext)this.partialAggContextImpl);
    }

    class PartialAggContextImpl
    implements VertexCentricAggregateFunction.IPartialAggContext<PR> {
        PartialAggContextImpl() {
        }

        public long getIteration() {
            return GraphVertexCentricOpAggregator.this.iteration;
        }

        public void collect(PR result) {
            GraphVertexCentricOpAggregator.this.aggregateCollector.partition(result);
        }
    }

    class VertexCentricAggContextImpl
    implements VertexCentricAggContextFunction.VertexCentricAggContext<I, GR> {
        VertexCentricAggContextImpl() {
        }

        public GR getAggregateResult() {
            return GraphVertexCentricOpAggregator.this.globalResult;
        }

        public void aggregate(I i) {
            GraphVertexCentricOpAggregator.this.partialResult = GraphVertexCentricOpAggregator.this.partialGraphAggFunction.aggregate(i, GraphVertexCentricOpAggregator.this.partialAgg);
        }
    }
}

