/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.impl.graph.algo.vc.context.dynamic;

import com.antgroup.geaflow.api.graph.function.vc.base.VertexCentricFunction;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.state.DynamicEdgeState;
import com.antgroup.geaflow.state.GraphState;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import com.antgroup.geaflow.state.pushdown.filter.InEdgeFilter;
import com.antgroup.geaflow.state.pushdown.filter.OutEdgeFilter;
import com.antgroup.geaflow.utils.keygroup.KeyGroup;
import java.util.List;

public class DynamicEdgeQueryImpl<K, VV, EV>
implements VertexCentricFunction.EdgeQuery<K, EV> {
    protected K vId;
    private long versionId;
    private GraphState<K, VV, EV> graphState;
    protected KeyGroup keyGroup;

    public DynamicEdgeQueryImpl(K vId, long versionId, GraphState<K, VV, EV> graphState) {
        this.vId = vId;
        this.versionId = versionId;
        this.graphState = graphState;
    }

    public DynamicEdgeQueryImpl(K vId, long versionId, GraphState<K, VV, EV> graphState, KeyGroup keyGroup) {
        this.vId = vId;
        this.versionId = versionId;
        this.graphState = graphState;
        this.keyGroup = keyGroup;
    }

    public List<IEdge<K, EV>> getEdges() {
        DynamicEdgeState edgeState = this.graphState.dynamicGraph().E();
        return edgeState.query(this.versionId, new Object[]{this.vId}).asList();
    }

    public List<IEdge<K, EV>> getOutEdges() {
        DynamicEdgeState edgeState = this.graphState.dynamicGraph().E();
        return edgeState.query(this.versionId, new Object[]{this.vId}).by((IFilter)OutEdgeFilter.instance()).asList();
    }

    public List<IEdge<K, EV>> getInEdges() {
        DynamicEdgeState edgeState = this.graphState.dynamicGraph().E();
        return edgeState.query(this.versionId, new Object[]{this.vId}).by((IFilter)InEdgeFilter.instance()).asList();
    }

    public List<IEdge<K, EV>> getEdges(IFilter edgeFilter) {
        DynamicEdgeState edgeState = this.graphState.dynamicGraph().E();
        return edgeState.query(this.versionId, new Object[]{this.vId}).by(edgeFilter).asList();
    }
}

