/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.impl.graph.algo.vc.context.dynamic;

import com.antgroup.geaflow.api.context.RuntimeContext;
import com.antgroup.geaflow.api.graph.function.vc.base.IncVertexCentricFunction;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.iterator.CloseableIterator;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.context.dynamic.IncHistoricalGraph;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.context.dynamic.IncMutableGraph;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.context.dynamic.IncTemporaryGraph;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.msgbox.IGraphMsgBox;
import com.antgroup.geaflow.operator.impl.graph.compute.dynamic.cache.TemporaryGraphCache;
import com.antgroup.geaflow.state.GraphState;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncGraphContextImpl<K, VV, EV, M>
implements IncVertexCentricFunction.IncGraphContext<K, VV, EV, M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncGraphContextImpl.class);
    private long iterationId;
    private K vertexId;
    private final Operator.OpContext opContext;
    private final RuntimeContext runtimeContext;
    private final IncHistoricalGraph<K, VV, EV> historicalGraph;
    private final IncTemporaryGraph<K, VV, EV> temporaryGraph;
    private final IncMutableGraph<K, VV, EV> mutableGraph;
    private final GraphState<K, VV, EV> graphState;
    private final IGraphMsgBox<K, M> graphMsgBox;
    private final long maxIteration;

    public IncGraphContextImpl(Operator.OpContext opContext, RuntimeContext runtimeContext, GraphState<K, VV, EV> graphState, TemporaryGraphCache<K, VV, EV> temporaryGraphCache, IGraphMsgBox<K, M> graphMsgBox, long maxIteration) {
        this.opContext = opContext;
        this.runtimeContext = runtimeContext;
        this.historicalGraph = new IncHistoricalGraph<K, VV, EV>(graphState);
        this.temporaryGraph = new IncTemporaryGraph<K, VV, EV>(temporaryGraphCache);
        this.mutableGraph = new IncMutableGraph<K, VV, EV>(graphState);
        this.graphMsgBox = graphMsgBox;
        this.graphState = graphState;
        this.maxIteration = maxIteration;
    }

    public void init(long iterationId, K vertexId) {
        this.iterationId = iterationId;
        this.vertexId = vertexId;
        this.historicalGraph.init(vertexId);
        this.temporaryGraph.init(vertexId);
    }

    public long getJobId() {
        return this.opContext.getRuntimeContext().getPipelineId();
    }

    public long getIterationId() {
        return this.iterationId;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public IncVertexCentricFunction.MutableGraph<K, VV, EV> getMutableGraph() {
        return this.mutableGraph;
    }

    public IncVertexCentricFunction.TemporaryGraph<K, VV, EV> getTemporaryGraph() {
        return this.temporaryGraph;
    }

    public IncVertexCentricFunction.HistoricalGraph<K, VV, EV> getHistoricalGraph() {
        return this.historicalGraph;
    }

    public void sendMessage(K vertexId, M m) {
        if (this.iterationId >= this.maxIteration) {
            return;
        }
        this.graphMsgBox.addOutMessage(vertexId, m);
    }

    public void sendMessageToNeighbors(M m) {
        if (this.iterationId >= this.maxIteration) {
            return;
        }
        List allVersions = this.graphState.dynamicGraph().V().getAllVersions(this.vertexId);
        Iterator iterator = allVersions.iterator();
        while (iterator.hasNext()) {
            long version = (Long)iterator.next();
            try {
                CloseableIterator edgeIterator = this.graphState.dynamicGraph().E().query(version, new Object[]{this.vertexId}).iterator();
                Throwable throwable = null;
                try {
                    while (edgeIterator.hasNext()) {
                        IEdge edge = (IEdge)edgeIterator.next();
                        this.graphMsgBox.addOutMessage(edge.getTargetId(), m);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (edgeIterator == null) continue;
                    if (throwable != null) {
                        try {
                            edgeIterator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    edgeIterator.close();
                }
            }
            catch (Exception e) {
                throw new GeaflowRuntimeException((Throwable)e);
            }
        }
    }
}

