/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.operator.impl.graph.algo.vc.context.statical;

import com.antgroup.geaflow.api.context.RuntimeContext;
import com.antgroup.geaflow.api.graph.function.vc.base.VertexCentricFunction;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.iterator.CloseableIterator;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.operator.Operator;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.context.statical.StaticEdgeQueryImpl;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.context.statical.StaticVertexQueryImpl;
import com.antgroup.geaflow.operator.impl.graph.algo.vc.msgbox.IGraphMsgBox;
import com.antgroup.geaflow.state.GraphState;

public class StaticGraphContextImpl<K, VV, EV, M>
implements VertexCentricFunction.VertexCentricFuncContext<K, VV, EV, M> {
    private final Operator.OpContext opContext;
    private final RuntimeContext runtimeContext;
    private final GraphState<K, VV, EV> graphState;
    private final IGraphMsgBox<K, M> graphMsgBox;
    private final long maxIteration;
    protected long iterationId;
    protected K vertexId;

    public StaticGraphContextImpl(Operator.OpContext opContext, RuntimeContext runtimeContext, GraphState<K, VV, EV> graphState, IGraphMsgBox<K, M> graphMsgBox, long maxIteration) {
        this.opContext = opContext;
        this.runtimeContext = runtimeContext;
        this.graphState = graphState;
        this.graphMsgBox = graphMsgBox;
        this.maxIteration = maxIteration;
    }

    public void init(long iterationId, K vertexId) {
        this.iterationId = iterationId;
        this.vertexId = vertexId;
    }

    public long getJobId() {
        return this.opContext.getRuntimeContext().getPipelineId();
    }

    public long getIterationId() {
        return this.iterationId;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public VertexCentricFunction.VertexQuery<K, VV> vertex() {
        return new StaticVertexQueryImpl<K, VV, EV>(this.vertexId, this.graphState);
    }

    public VertexCentricFunction.EdgeQuery<K, EV> edges() {
        return new StaticEdgeQueryImpl<K, VV, EV>(this.vertexId, this.graphState);
    }

    public void sendMessage(K vertexId, M message) {
        if (this.iterationId >= this.maxIteration) {
            return;
        }
        this.graphMsgBox.addOutMessage(vertexId, message);
    }

    public void sendMessageToNeighbors(M message) {
        if (this.iterationId >= this.maxIteration) {
            return;
        }
        try (CloseableIterator edgeIterator = this.graphState.staticGraph().E().query(this.vertexId).iterator();){
            while (edgeIterator.hasNext()) {
                IEdge edge = (IEdge)edgeIterator.next();
                this.graphMsgBox.addOutMessage(edge.getTargetId(), message);
            }
        }
        catch (Exception e) {
            throw new GeaflowRuntimeException((Throwable)e);
        }
    }
}

